/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import java.util.Map;
import okhttp3.FormBody;
import okhttp3.MediaType;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OkHttpUtil {
    private static final Logger log = LoggerFactory.getLogger(OkHttpUtil.class);
    public static MediaType JSON = MediaType.parse((String)"application/json; charset=utf-8");
    public static MediaType XML = MediaType.parse((String)"application/xml; charset=utf-8");

    public static String get(String url, Map<String, String> queries) {
        return OkHttpUtil.get(url, null, queries);
    }

    public static String get(String url, Map<String, String> header, Map<String, String> queries) {
        StringBuffer sb = new StringBuffer(url);
        if (queries != null && queries.keySet().size() > 0) {
            sb.append("?clientId=blade");
            queries.forEach((k, v) -> sb.append("&").append((String)k).append("=").append((String)v));
        }
        Request.Builder builder = new Request.Builder();
        if (header != null && header.keySet().size() > 0) {
            header.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.url(sb.toString()).build();
        return OkHttpUtil.getBody(request);
    }

    public static String post(String url, Map<String, String> params) {
        return OkHttpUtil.post(url, null, params);
    }

    public static String post(String url, Map<String, String> header, Map<String, String> params) {
        FormBody.Builder formBuilder = new FormBody.Builder().add("clientId", "blade");
        if (params != null && params.keySet().size() > 0) {
            params.forEach((arg_0, arg_1) -> ((FormBody.Builder)formBuilder).add(arg_0, arg_1));
        }
        Request.Builder builder = new Request.Builder();
        if (header != null && header.keySet().size() > 0) {
            header.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.url(url).post((RequestBody)formBuilder.build()).build();
        return OkHttpUtil.getBody(request);
    }

    public static String postJson(String url, String json) {
        return OkHttpUtil.postJson(url, null, json);
    }

    public static String postJson(String url, Map<String, String> header, String json) {
        return OkHttpUtil.postContent(url, header, json, JSON);
    }

    public static String postXml(String url, String xml) {
        return OkHttpUtil.postXml(url, null, xml);
    }

    public static String postXml(String url, Map<String, String> header, String xml) {
        return OkHttpUtil.postContent(url, header, xml, XML);
    }

    public static String postContent(String url, Map<String, String> header, String content, MediaType mediaType) {
        RequestBody requestBody = RequestBody.create((MediaType)mediaType, (String)content);
        Request.Builder builder = new Request.Builder();
        if (header != null && header.keySet().size() > 0) {
            header.forEach((arg_0, arg_1) -> ((Request.Builder)builder).addHeader(arg_0, arg_1));
        }
        Request request = builder.url(url).post(requestBody).build();
        return OkHttpUtil.getBody(request);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String getBody(Request request) {
        String responseBody = "";
        try (Response response = null;){
            OkHttpClient okHttpClient = new OkHttpClient();
            response = okHttpClient.newCall(request).execute();
            if (response.isSuccessful()) {
                String string = response.body().string();
                return string;
            }
        }
        return responseBody;
    }
}

