/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.utils.Charsets;
import ink.rayin.tools.utils.Exceptions;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import org.springframework.lang.Nullable;
import org.springframework.util.StreamUtils;

public class IoUtil
extends StreamUtils {
    public static void closeQuietly(@Nullable Closeable closeable) {
        try {
            if (closeable != null) {
                closeable.close();
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static String toString(InputStream input) {
        return IoUtil.toString(input, Charsets.UTF_8);
    }

    public static String toString(@Nullable InputStream input, Charset charset) {
        try {
            String string = IoUtil.copyToString((InputStream)input, (Charset)charset);
            return string;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
        finally {
            IoUtil.closeQuietly(input);
        }
    }

    public static byte[] toByteArray(@Nullable InputStream input) {
        try {
            byte[] byArray = IoUtil.copyToByteArray((InputStream)input);
            return byArray;
        }
        catch (IOException e) {
            throw Exceptions.unchecked(e);
        }
        finally {
            IoUtil.closeQuietly(input);
        }
    }

    public static void write(@Nullable String data, OutputStream output, Charset encoding) throws IOException {
        if (data != null) {
            output.write(data.getBytes(encoding));
        }
    }
}

