/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.utils.StringUtil;

public class DisplayMeasureConvert {
    public static float pixelsToPoints(float pixels, int dpi) {
        return pixels / (float)dpi * 72.0f;
    }

    public static float pixelsToCm(float pixels, int dpi) {
        return pixels / (float)dpi * 2.54f;
    }

    public static float cmToPixels(float cm, int dpi) {
        return cm / 2.54f * (float)dpi;
    }

    public static float pixelsToInches(float pixels, int dpi) {
        return pixels / (float)dpi;
    }

    public static float InchesToPixels(float inches, int dpi) {
        return inches * (float)dpi;
    }

    public static float cmToPoints(float cm, int dpi) {
        return DisplayMeasureConvert.pixelsToPoints(DisplayMeasureConvert.cmToPixels(cm, dpi), dpi);
    }

    public static float inchesToPoints(float cm, int dpi) {
        return DisplayMeasureConvert.pixelsToPoints(DisplayMeasureConvert.InchesToPixels(cm, dpi), dpi);
    }

    public static float webMeasureToPDFPoint(String meas) {
        int DPI = 96;
        String lower = meas.toLowerCase();
        if (meas.trim().length() < 3) {
            return Float.valueOf(meas).floatValue();
        }
        if (StringUtil.isNumeric(meas)) {
            return Float.valueOf(meas).floatValue();
        }
        String mes = meas.substring(lower.length() - 2, lower.length());
        float f = Float.valueOf(lower.substring(0, lower.length() - 2)).floatValue();
        switch (mes) {
            case "px": {
                return DisplayMeasureConvert.pixelsToPoints(f, DPI);
            }
            case "cm": {
                return DisplayMeasureConvert.cmToPoints(f, DPI);
            }
            case "in": {
                return DisplayMeasureConvert.inchesToPoints(f, DPI);
            }
        }
        return f;
    }

    public static void main(String[] args) {
        System.out.println(DisplayMeasureConvert.webMeasureToPDFPoint("20.5cm"));
    }
}

