/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.utils.Charsets;
import ink.rayin.tools.utils.Exceptions;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.springframework.lang.Nullable;
import org.springframework.util.DigestUtils;

public class DigestUtil
extends DigestUtils {
    private static final char[] HEX_DIGITS = "0123456789abcdef".toCharArray();

    public static String md5Hex(String data) {
        return DigestUtil.md5DigestAsHex((byte[])data.getBytes(Charsets.UTF_8));
    }

    public static String md5Hex(byte[] bytes) {
        return DigestUtil.md5DigestAsHex((byte[])bytes);
    }

    public static String sha1(String srcStr) {
        return DigestUtil.hash("SHA-1", srcStr);
    }

    public static String sha256(String srcStr) {
        return DigestUtil.hash("SHA-256", srcStr);
    }

    public static String sha384(String srcStr) {
        return DigestUtil.hash("SHA-384", srcStr);
    }

    public static String sha512(String srcStr) {
        return DigestUtil.hash("SHA-512", srcStr);
    }

    public static String hash(String algorithm, String srcStr) {
        try {
            MessageDigest md = MessageDigest.getInstance(algorithm);
            byte[] bytes = md.digest(srcStr.getBytes(Charsets.UTF_8));
            return DigestUtil.toHex(bytes);
        }
        catch (NoSuchAlgorithmException e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static String toHex(byte[] bytes) {
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
            ret.append(HEX_DIGITS[bytes[i] & 0xF]);
        }
        return ret.toString();
    }

    public static boolean slowEquals(@Nullable String a, @Nullable String b) {
        if (a == null || b == null) {
            return false;
        }
        return DigestUtil.slowEquals(a.getBytes(Charsets.UTF_8), b.getBytes(Charsets.UTF_8));
    }

    public static boolean slowEquals(@Nullable byte[] a, @Nullable byte[] b) {
        if (a == null || b == null) {
            return false;
        }
        if (a.length != b.length) {
            return false;
        }
        int diff = a.length ^ b.length;
        for (int i = 0; i < a.length && i < b.length; ++i) {
            diff |= a[i] ^ b[i];
        }
        return diff == 0;
    }

    public static String encrypt(String data) {
        return DigestUtil.sha1(DigestUtil.md5Hex(data));
    }
}

