/*
 * Decompiled with CFR 0.152.
 */
package ink.rayin.tools.utils;

import ink.rayin.tools.utils.Charsets;
import ink.rayin.tools.utils.Exceptions;
import ink.rayin.tools.utils.StringUtil;
import java.nio.charset.Charset;
import java.security.Key;
import java.util.Arrays;
import javax.crypto.Cipher;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.springframework.util.Assert;

public class AesUtil {
    private AesUtil() {
    }

    public static String genAesKey() {
        return StringUtil.random(32);
    }

    public static byte[] encrypt(byte[] content, String aesTextKey) {
        return AesUtil.encrypt(content, aesTextKey.getBytes(Charsets.UTF_8));
    }

    public static byte[] encrypt(String content, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(Charsets.UTF_8), aesTextKey.getBytes(Charsets.UTF_8));
    }

    public static byte[] encrypt(String content, Charset charset, String aesTextKey) {
        return AesUtil.encrypt(content.getBytes(charset), aesTextKey.getBytes(Charsets.UTF_8));
    }

    public static byte[] decrypt(byte[] content, String aesTextKey) {
        return AesUtil.decrypt(content, aesTextKey.getBytes(Charsets.UTF_8));
    }

    public static String decryptToStr(byte[] content, String aesTextKey) {
        return new String(AesUtil.decrypt(content, aesTextKey.getBytes(Charsets.UTF_8)), Charsets.UTF_8);
    }

    public static String decryptToStr(byte[] content, String aesTextKey, Charset charset) {
        return new String(AesUtil.decrypt(content, aesTextKey.getBytes(Charsets.UTF_8)), charset);
    }

    public static byte[] encrypt(byte[] content, byte[] aesKey) {
        Assert.isTrue((aesKey.length == 32 ? 1 : 0) != 0, (String)"IllegalAesKey, aesKey's length must be 32");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(aesKey, 0, 16);
            cipher.init(1, (Key)keySpec, iv);
            return cipher.doFinal(Pkcs7Encoder.encode(content));
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    public static byte[] decrypt(byte[] encrypted, byte[] aesKey) {
        Assert.isTrue((aesKey.length == 32 ? 1 : 0) != 0, (String)"IllegalAesKey, aesKey's length must be 32");
        try {
            Cipher cipher = Cipher.getInstance("AES/CBC/NoPadding");
            SecretKeySpec keySpec = new SecretKeySpec(aesKey, "AES");
            IvParameterSpec iv = new IvParameterSpec(Arrays.copyOfRange(aesKey, 0, 16));
            cipher.init(2, (Key)keySpec, iv);
            return Pkcs7Encoder.decode(cipher.doFinal(encrypted));
        }
        catch (Exception e) {
            throw Exceptions.unchecked(e);
        }
    }

    static class Pkcs7Encoder {
        static int BLOCK_SIZE = 32;

        Pkcs7Encoder() {
        }

        static byte[] encode(byte[] src) {
            int count = src.length;
            int amountToPad = BLOCK_SIZE - count % BLOCK_SIZE;
            if (amountToPad == 0) {
                amountToPad = BLOCK_SIZE;
            }
            byte pad = (byte)(amountToPad & 0xFF);
            byte[] pads = new byte[amountToPad];
            for (int index = 0; index < amountToPad; ++index) {
                pads[index] = pad;
            }
            int length = count + amountToPad;
            byte[] dest = new byte[length];
            System.arraycopy(src, 0, dest, 0, count);
            System.arraycopy(pads, 0, dest, count, amountToPad);
            return dest;
        }

        static byte[] decode(byte[] decrypted) {
            byte pad = decrypted[decrypted.length - 1];
            if (pad < 1 || pad > BLOCK_SIZE) {
                pad = 0;
            }
            if (pad > 0) {
                return Arrays.copyOfRange(decrypted, 0, decrypted.length - pad);
            }
            return decrypted;
        }
    }
}

