/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.xdocreport.document.images;

import fr.opensagres.xdocreport.document.images.ByteArrayImageProvider;
import fr.opensagres.xdocreport.document.images.FileImageProvider;
import fr.opensagres.xdocreport.document.images.IImageHandler;
import fr.opensagres.xdocreport.document.images.IImageProvider;
import fr.opensagres.xdocreport.template.formatter.FieldMetadata;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;

public class DefaultImageHandler
implements IImageHandler {
    private static final IImageHandler INSTANCE = new DefaultImageHandler();
    private boolean defaultUseImageSize = false;

    public static IImageHandler getInstance() {
        return INSTANCE;
    }

    @Override
    public IImageProvider getImageProvider(Object image, String fieldName, FieldMetadata metadata) throws IOException {
        if (image instanceof InputStream) {
            return this.getImageProvider((InputStream)image, fieldName, metadata);
        }
        if (image instanceof byte[]) {
            return this.getImageProvider((byte[])image, fieldName, metadata);
        }
        if (image instanceof File) {
            return this.getImageProvider((File)image, fieldName, metadata);
        }
        return null;
    }

    protected IImageProvider getImageProvider(InputStream imageStream, String fieldName, FieldMetadata metadata) throws IOException {
        return new ByteArrayImageProvider(imageStream, this.isUseImageSize(fieldName, metadata));
    }

    protected IImageProvider getImageProvider(byte[] imageByteArray, String fieldName, FieldMetadata metadata) throws IOException {
        return new ByteArrayImageProvider(imageByteArray, this.isUseImageSize(fieldName, metadata));
    }

    protected IImageProvider getImageProvider(File imageFile, String fieldName, FieldMetadata metadata) throws IOException {
        return new FileImageProvider(imageFile, this.isUseImageSize(fieldName, metadata));
    }

    public boolean isUseImageSize(String fieldName, FieldMetadata metadata) {
        if (metadata != null) {
            return metadata.isUseImageSize();
        }
        return this.defaultUseImageSize;
    }

    public boolean isDefaultUseImageSize() {
        return this.defaultUseImageSize;
    }

    public void setDefaultUseImageSize(boolean defaultUseImageSize) {
        this.defaultUseImageSize = defaultUseImageSize;
    }
}

