/*
 * Decompiled with CFR 0.152.
 */
package fr.opensagres.poi.xwpf.converter.pdf.internal.elements;

import com.google.code.appengine.awt.Color;
import com.lowagie.text.Element;
import com.lowagie.text.pdf.PdfPTable;
import fr.opensagres.poi.xwpf.converter.core.TableCellBorder;
import fr.opensagres.poi.xwpf.converter.pdf.internal.Converter;
import fr.opensagres.poi.xwpf.converter.pdf.internal.elements.StylableDocument;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPCell;
import fr.opensagres.xdocreport.itext.extension.ExtendedPdfPTable;
import fr.opensagres.xdocreport.itext.extension.IITextContainer;

public class StylableTableCell
extends ExtendedPdfPCell
implements IITextContainer {
    private final StylableDocument ownerDocument;
    private final IITextContainer parent;

    public StylableTableCell(StylableDocument ownerDocument, IITextContainer parent) {
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        this.getColumn().setAdjustFirstLine(false);
        this.setUseBorderPadding(true);
        this.setPadding(0.0f);
    }

    public StylableTableCell(StylableDocument ownerDocument, IITextContainer parent, ExtendedPdfPTable table) {
        super((PdfPTable)table);
        this.ownerDocument = ownerDocument;
        this.parent = parent;
        this.getColumn().setAdjustFirstLine(false);
        this.setUseBorderPadding(true);
    }

    public void addElement(Element element) {
        super.addElement(element);
    }

    public IITextContainer getParent() {
        return this.parent;
    }

    public Element getElement() {
        return this;
    }

    public void setBorderTop(TableCellBorder borderTop, boolean inside) {
        this.setBorder(borderTop, inside, 1);
    }

    public void setBorderBottom(TableCellBorder borderBottom, boolean inside) {
        this.setBorder(borderBottom, inside, 2);
    }

    public void setBorderLeft(TableCellBorder borderLeft, boolean inside) {
        this.setBorder(borderLeft, inside, 4);
    }

    public void setBorderRight(TableCellBorder borderRight, boolean inside) {
        this.setBorder(borderRight, inside, 8);
    }

    public void setBorder(TableCellBorder border, boolean inside, int borderSide) {
        if (border == null || !border.hasBorder()) {
            this.disableBorderSide(borderSide);
            return;
        }
        Float borderSize = border.getBorderSize();
        if (inside) {
            borderSize = Float.valueOf(borderSize.floatValue() / 2.0f);
        }
        Color borderColor = Converter.toAwtColor(border.getBorderColor());
        switch (borderSide) {
            case 1: {
                if (borderSize != null) {
                    this.setBorderWidthTop(borderSize.floatValue());
                }
                if (borderColor == null) break;
                this.setBorderColorTop(borderColor);
                break;
            }
            case 2: {
                if (borderSize != null) {
                    this.setBorderWidthBottom(borderSize.floatValue());
                }
                if (borderColor == null) break;
                this.setBorderColorBottom(borderColor);
                break;
            }
            case 4: {
                if (borderSize != null) {
                    this.setBorderWidthLeft(borderSize.floatValue());
                }
                if (borderColor == null) break;
                this.setBorderColorLeft(borderColor);
                break;
            }
            case 8: {
                if (borderSize != null) {
                    this.setBorderWidthRight(borderSize.floatValue());
                }
                if (borderColor == null) break;
                this.setBorderColorRight(borderColor);
            }
        }
    }
}

