/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.sms.model;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="t_team_leader")
public class TTeamLeader
extends AbsModel {
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="end_date")
    @JsonProperty(value="end_date")
    private Date endDate;
    @Column(name="leader_name")
    @JsonProperty(value="leader_name")
    private String leaderName;
    @Column(name="person_no")
    @JsonProperty(value="person_no")
    private String personNo;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="start_date")
    @JsonProperty(value="start_date")
    private Date startDate;
    @Column(name="status")
    @JsonProperty(value="status")
    private String status;
    @Column(name="team_no")
    @JsonProperty(value="team_no")
    private String teamNo;
    @Transient
    @JsonIgnore
    private Where<TTeamLeader> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<TTeamLeader> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field END_DATE = new Field("endDate", "end_date");
    @Transient
    public static final Field LEADER_NAME = new Field("leaderName", "leader_name");
    @Transient
    public static final Field PERSON_NO = new Field("personNo", "person_no");
    @Transient
    public static final Field START_DATE = new Field("startDate", "start_date");
    @Transient
    public static final Field STATUS = new Field("status", "status");
    @Transient
    public static final Field TEAM_NO = new Field("teamNo", "team_no");

    public TTeamLeader() {
    }

    public TTeamLeader(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String teamNo;
        String status;
        String personNo;
        Return ret = new Return();
        String leaderName = StrUtils.trimStr((Object)this.leaderName);
        if (leaderName.length() > 50) {
            ret.setFailMsg("[\u56e2\u957f\u540d\u79f0]\u4e0d\u80fd\u8d85\u8fc7[50]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + leaderName.length() + "]\u4f4d");
        }
        if ((personNo = StrUtils.trimStr((Object)this.personNo)).length() > 25) {
            ret.setFailMsg("[\u4eba\u5458id]\u4e0d\u80fd\u8d85\u8fc7[25]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + personNo.length() + "]\u4f4d");
        }
        if ((status = StrUtils.trimStr((Object)this.status)).length() > 32) {
            ret.setFailMsg("[\u72b6\u6001]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + status.length() + "]\u4f4d");
        }
        if ((teamNo = StrUtils.trimStr((Object)this.teamNo)).length() > 30) {
            ret.setFailMsg("[\u7ec4\u7ec7id]\u4e0d\u80fd\u8d85\u8fc7[30]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + teamNo.length() + "]\u4f4d");
        }
        return ret;
    }

    public TTeamLeader setEndDate(Date endDate) {
        this.endDate = endDate;
        this.where().setChangeColumn(END_DATE);
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public TTeamLeader setLeaderName(String leaderName) {
        this.leaderName = leaderName;
        this.where().setChangeColumn(LEADER_NAME);
        return this;
    }

    public String getLeaderName() {
        return this.leaderName;
    }

    public TTeamLeader setPersonNo(String personNo) {
        this.personNo = personNo;
        this.where().setChangeColumn(PERSON_NO);
        return this;
    }

    public String getPersonNo() {
        return this.personNo;
    }

    public TTeamLeader setStartDate(Date startDate) {
        this.startDate = DateUtils.trunc((Date)startDate);
        this.where().setChangeColumn(START_DATE);
        return this;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    public TTeamLeader setStatus(String status) {
        this.status = status;
        this.where().setChangeColumn(STATUS);
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public TTeamLeader setTeamNo(String teamNo) {
        this.teamNo = teamNo;
        this.where().setChangeColumn(TEAM_NO);
        return this;
    }

    public String getTeamNo() {
        return this.teamNo;
    }

    @JsonIgnore
    public TTeamLeader select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<TTeamLeader> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<TTeamLeader> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public TTeamLeader setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static TTeamLeader n() {
        return new TTeamLeader();
    }

    @JsonIgnore
    public static TTeamLeader n(boolean appendWhere) {
        return new TTeamLeader(appendWhere);
    }
}

