/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.sms.model.person;

import com.fasterxml.jackson.annotation.JsonFormat;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.StrUtils;
import java.util.Date;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="t_person_dept")
public class TPersonDept
extends AbsModel {
    @Column(name="dept_no")
    @JsonProperty(value="dept_no")
    private String deptNo;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="end_date")
    @JsonProperty(value="end_date")
    private Date endDate;
    @Column(name="person_no")
    @JsonProperty(value="person_no")
    private String personNo;
    @JsonFormat(pattern="yyyy-MM-dd")
    @Column(name="start_date")
    @JsonProperty(value="start_date")
    private Date startDate;
    @Transient
    @JsonIgnore
    private Where<TPersonDept> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<TPersonDept> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field DEPT_NO = new Field("deptNo", "dept_no");
    @Transient
    public static final Field END_DATE = new Field("endDate", "end_date");
    @Transient
    public static final Field PERSON_NO = new Field("personNo", "person_no");
    @Transient
    public static final Field START_DATE = new Field("startDate", "start_date");

    public TPersonDept() {
    }

    public TPersonDept(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String personNo;
        Return ret = new Return();
        String deptNo = StrUtils.trimStr((Object)this.deptNo);
        if (deptNo.length() > 32) {
            ret.setFailMsg("[\u673a\u6784\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + deptNo.length() + "]\u4f4d");
        }
        if ((personNo = StrUtils.trimStr((Object)this.personNo)).length() > 22) {
            ret.setFailMsg("[\u4eba\u5458\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[22]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + personNo.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.personNo)) {
            ret.setFailMsg("[\u4eba\u5458\u4ee3\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ret;
    }

    public TPersonDept setDeptNo(String deptNo) {
        this.deptNo = deptNo;
        this.where().setChangeColumn(DEPT_NO);
        return this;
    }

    public String getDeptNo() {
        return this.deptNo;
    }

    public TPersonDept setEndDate(Date endDate) {
        this.endDate = endDate;
        this.where().setChangeColumn(END_DATE);
        return this;
    }

    public Date getEndDate() {
        return this.endDate;
    }

    public TPersonDept setPersonNo(String personNo) {
        this.personNo = personNo;
        this.where().setChangeColumn(PERSON_NO);
        return this;
    }

    public String getPersonNo() {
        return this.personNo;
    }

    public TPersonDept setStartDate(Date startDate) {
        this.startDate = DateUtils.trunc((Date)startDate);
        this.where().setChangeColumn(START_DATE);
        return this;
    }

    public Date getStartDate() {
        return this.startDate;
    }

    @JsonIgnore
    public TPersonDept select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<TPersonDept> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<TPersonDept> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public TPersonDept setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static TPersonDept n() {
        return new TPersonDept();
    }

    @JsonIgnore
    public static TPersonDept n(boolean appendWhere) {
        return new TPersonDept(appendWhere);
    }
}

