/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.sms.model.base;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
import java.util.Objects;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="t_risk")
public class TRisk
extends AbsModel {
    @Column(name="class_name")
    @JsonProperty(value="class_name")
    private String className;
    @Column(name="class_no")
    @JsonProperty(value="class_no")
    private String classNo;
    @Column(name="class_parent")
    @JsonProperty(value="class_parent")
    private String classParent;
    @Column(name="class_type")
    @JsonProperty(value="class_type")
    private String classType;
    @Transient
    @JsonIgnore
    private Where<TRisk> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<TRisk> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field CLASS_NAME = new Field("className", "class_name");
    @Transient
    public static final Field CLASS_NO = new Field("classNo", "class_no");
    @Transient
    public static final Field CLASS_PARENT = new Field("classParent", "class_parent");
    @Transient
    public static final Field CLASS_TYPE = new Field("classType", "class_type");

    public TRisk() {
    }

    public TRisk(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String classType;
        String classParent;
        String classNo;
        Return ret = new Return();
        String className = StrUtils.trimStr((Object)this.className);
        if (className.length() > 100) {
            ret.setFailMsg("[\u540d\u79f0]\u4e0d\u80fd\u8d85\u8fc7[100]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + className.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.className)) {
            ret.setFailMsg("[\u540d\u79f0]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((classNo = StrUtils.trimStr((Object)this.classNo)).length() > 32) {
            ret.setFailMsg("[\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + classNo.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.classNo)) {
            ret.setFailMsg("[\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((classParent = StrUtils.trimStr((Object)this.classParent)).length() > 32) {
            ret.setFailMsg("[\u7236\u7ea7]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + classParent.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.classParent)) {
            ret.setFailMsg("[\u7236\u7ea7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((classType = StrUtils.trimStr((Object)this.classType)).length() > 4) {
            ret.setFailMsg("[\u7c7b\u578b]\u4e0d\u80fd\u8d85\u8fc7[4]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + classType.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.classType)) {
            ret.setFailMsg("[\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ret;
    }

    public TRisk setClassName(String className) {
        this.className = className;
        this.where().setChangeColumn(CLASS_NAME);
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public TRisk setClassNo(String classNo) {
        this.classNo = classNo;
        this.where().setChangeColumn(CLASS_NO);
        return this;
    }

    public String getClassNo() {
        return this.classNo;
    }

    public TRisk setClassParent(String classParent) {
        this.classParent = classParent;
        this.where().setChangeColumn(CLASS_PARENT);
        return this;
    }

    public String getClassParent() {
        return this.classParent;
    }

    public TRisk setClassType(String classType) {
        this.classType = classType;
        this.where().setChangeColumn(CLASS_TYPE);
        return this;
    }

    public String getClassType() {
        return this.classType;
    }

    @JsonIgnore
    public TRisk select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<TRisk> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<TRisk> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public TRisk setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        return obj != null && obj.getClass() == ((Object)((Object)this)).getClass();
    }

    public int hashCode() {
        return Objects.hash(this.classNo, this.className);
    }

    @JsonIgnore
    public static TRisk n() {
        return new TRisk();
    }

    @JsonIgnore
    public static TRisk n(boolean appendWhere) {
        return new TRisk(appendWhere);
    }
}

