/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.sms.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="t_error_log")
public class TErrorLog
extends AbsModel {
    @Column(name="class_name")
    @JsonProperty(value="class_name")
    private String className;
    @Column(name="error_message")
    @JsonProperty(value="error_message")
    private String errorMessage;
    @Column(name="method")
    @JsonProperty(value="method")
    private String method;
    @Column(name="month")
    @JsonProperty(value="month")
    private String month;
    @Transient
    @JsonIgnore
    private Where<TErrorLog> where = Where.getInstance((AbsModel)this);
    @Transient
    @JsonIgnore
    private GroupBy<TErrorLog> groupby = GroupBy.getInstance((AbsModel)this);
    @Transient
    public static final Field ERROR_MESSAGE = new Field("className", "class_name");
    @Transient
    public static final Field CLASS_NAME = new Field("errorMessage", "error_message");
    @Transient
    public static final Field METHOD = new Field("method", "method");
    @Transient
    public static final Field MONTH = new Field("month", "month");

    public TErrorLog() {
    }

    public TErrorLog(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String month;
        String method;
        String errorMessage;
        Return ret = new Return();
        String className = StrUtils.trimStr((Object)this.className);
        if (className.length() > 32) {
            ret.setFailMsg("[\u7c7b\u540d]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + className.length() + "]\u4f4d");
        }
        if ((errorMessage = StrUtils.trimStr((Object)this.errorMessage)).length() > 1024) {
            ret.setFailMsg("[\u9519\u8bef\u4fe1\u606f]\u4e0d\u80fd\u8d85\u8fc7[1024]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + errorMessage.length() + "]\u4f4d");
        }
        if ((method = StrUtils.trimStr((Object)this.method)).length() > 32) {
            ret.setFailMsg("[\u65b9\u6cd5]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + method.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.method)) {
            ret.setFailMsg("[\u65b9\u6cd5]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((month = StrUtils.trimStr((Object)this.month)).length() > 32) {
            ret.setFailMsg("[\u5e74\u6708]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + month.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.month)) {
            ret.setFailMsg("[\u5e74\u6708]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return ret;
    }

    public TErrorLog setClassName(String className) {
        this.className = className;
        this.where().setChangeColumn(CLASS_NAME);
        return this;
    }

    public String getClassName() {
        return this.className;
    }

    public TErrorLog setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
        this.where().setChangeColumn(ERROR_MESSAGE);
        return this;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public TErrorLog setMethod(String method) {
        this.method = method;
        this.where().setChangeColumn(METHOD);
        return this;
    }

    public String getMethod() {
        return this.method;
    }

    public TErrorLog setMonth(String month) {
        this.month = month;
        this.where().setChangeColumn(MONTH);
        return this;
    }

    public String getMonth() {
        return this.month;
    }

    @JsonIgnore
    public TErrorLog select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<TErrorLog> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<TErrorLog> groupBy() {
        return this.groupby;
    }

    @JsonIgnore
    public TErrorLog setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static TErrorLog n() {
        return new TErrorLog();
    }

    @JsonIgnore
    public static TErrorLog n(boolean appendWhere) {
        return new TErrorLog(appendWhere);
    }
}

