/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.fasterxml.jackson.annotation.JsonFilter;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.PropertyWriter;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.uniapis.logger.Env;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JsonFilter(value="UniApisJsonFilter")
public class UniApisJsonFilter
extends SimpleBeanPropertyFilter {
    private Set<String> excludes = new HashSet<String>();
    private Map<Class<?>, Set<String>> classExcludes = new HashMap();
    private Map<String, Set<String>> tempClassExcludes = new HashMap<String, Set<String>>();
    private Set<Class<?>> applyClass = new HashSet();

    public void serializeAsField(Object pojo, JsonGenerator jgen, SerializerProvider prov, PropertyWriter writer) throws Exception {
        boolean isExcludes = this.isExcludes(pojo.getClass(), writer.getName());
        if (!isExcludes) {
            writer.serializeAsField(pojo, jgen, prov);
        } else if (!jgen.canOmitFields()) {
            writer.serializeAsOmittedField(pojo, jgen, prov);
        }
    }

    private boolean isExcludes(Class<?> clazz, String field) {
        if (this.excludes.contains(field)) {
            return true;
        }
        if (Map.class.isAssignableFrom(clazz)) {
            return false;
        }
        if (this.tempClassExcludes.get(clazz.getName()) == null) {
            return false;
        }
        return this.tempClassExcludes.get(clazz.getName()).contains(field);
    }

    public void addBaseExcludes(String ... fields) {
        for (String field : fields) {
            this.excludes.add(field);
        }
    }

    public void addExcludes(Class<?> clazz, String ... fields) {
        HashSet<String> set = new HashSet<String>();
        for (String field : fields) {
            set.add(field);
        }
        this.classExcludes.put(clazz, set);
    }

    public void addApplyClass(Class<?> ... classes) {
        for (Class<?> clazz : classes) {
            this.applyClass.add(clazz);
        }
    }

    public Set<Class<?>> getApplyClass() {
        this.applyClass.addAll(this.classExcludes.keySet());
        return this.applyClass;
    }

    public void removeExcludes(List<String> includes) {
        this.excludes.removeAll(includes);
    }

    public static UniApisJsonFilter dbExcludes() {
        UniApisJsonFilter filter = new UniApisJsonFilter();
        List fields = Env.env().excludeFields();
        if (!fields.isEmpty()) {
            filter.addBaseExcludes(fields.toArray(new String[0]));
            return filter;
        }
        filter.addBaseExcludes("serno", "crt_user", "crt_date", "mdf_user", "mdf_date", "data_flag", "patch_memo");
        return filter;
    }
}

