/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.logger.Ulog;
import com.uniapis.utils.StrUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.beans.BeanUtils;

public class ClassUtils {
    private static final Map<Class<?>, List<Field>> CLASS_FIELDS_CACHE = new ConcurrentHashMap();
    private static final Map<String, Field> FIELD_CACHE = new ConcurrentHashMap<String, Field>();
    private static final Map<String, Method> SETTER_CACHE = new ConcurrentHashMap<String, Method>();
    private static final Method NO_SETTER_MARKER;

    public static void copyProperties(Object source, Object target) {
        List<Field> fields = ClassUtils.getClassFields(source.getClass());
        for (Field field : fields) {
            Object tv;
            Object sv = ClassUtils.getProperty(source, field.getName());
            if (Objects.equals(sv, tv = ClassUtils.getProperty(target, field.getName()))) continue;
            if (sv != null) {
                ClassUtils.setProperty(target, field.getName(), sv);
                continue;
            }
            ClassUtils.setProperty(target, field.getName(), null);
        }
    }

    public static void setProperty(Object data, String field, Object value) {
        Field aField = ClassUtils.getField(data, field);
        if (aField == null) {
            return;
        }
        String setterKey = data.getClass().getName() + "#set" + StrUtils.uppFstChar(field);
        Method method = SETTER_CACHE.get(setterKey);
        if (method == null) {
            try {
                method = data.getClass().getMethod("set" + StrUtils.uppFstChar(field), aField.getType());
                method.setAccessible(true);
                SETTER_CACHE.put(setterKey, method);
            }
            catch (Exception e) {
                SETTER_CACHE.put(setterKey, NO_SETTER_MARKER);
            }
        }
        if (method != null && method != NO_SETTER_MARKER) {
            try {
                method.invoke(data, value);
                return;
            }
            catch (Exception e) {
                Ulog.debug((String)("\u8bbe\u7f6e\u503c\u51fa\u9519\uff1adataType[" + data.getClass().getName() + "],column[" + field + "],value[" + value + "]" + e.getMessage()));
            }
        }
        try {
            aField.set(data, value);
        }
        catch (Exception e) {
            try {
                aField.set(data, StrUtils.trimStr(value));
            }
            catch (Exception e1) {
                Ulog.warn((String)("\u8bbe\u7f6e\u503c\u51fa\u9519\uff1adataType[" + data.getClass().getName() + "],column[" + field + "],value[" + value + "]" + e1.getMessage()));
            }
        }
    }

    public static Object getProperty(Object arg, String field) {
        Field aField = ClassUtils.getField(arg, field);
        if (aField != null) {
            try {
                return aField.get(arg);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field getField(Object arg, String field) {
        String fieldKey = arg.getClass().getName() + "#" + field;
        return FIELD_CACHE.computeIfAbsent(fieldKey, k -> ClassUtils.findField(arg, field));
    }

    private static Field findField(Object arg, String field) {
        for (Class<?> clazz = arg.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                Field aField = clazz.getDeclaredField(field);
                aField.setAccessible(true);
                return aField;
            }
            catch (NoSuchFieldException noSuchFieldException) {
                continue;
            }
        }
        return null;
    }

    public static List<Field> getClassFields(Class<?> cla) {
        return CLASS_FIELDS_CACHE.computeIfAbsent(cla, k -> ClassUtils.collectClassFieldsRecursively(cla));
    }

    private static List<Field> collectClassFieldsRecursively(Class<?> cla) {
        ArrayList<Field> fields = new ArrayList<Field>();
        ClassUtils.collectFields(cla, fields);
        return Collections.unmodifiableList(fields);
    }

    private static void collectFields(Class<?> clazz, List<Field> fields) {
        Field[] fieldArray;
        if (clazz == null || clazz == Object.class) {
            return;
        }
        ClassUtils.collectFields(clazz.getSuperclass(), fields);
        for (Field field : fieldArray = clazz.getDeclaredFields()) {
            field.setAccessible(true);
            fields.add(field);
        }
    }

    public static Class<?> getFieldGenericity(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)field.getGenericType();
            Class c = (Class)pt.getActualTypeArguments()[0];
            return c;
        }
        return null;
    }

    public static void clearCache() {
        CLASS_FIELDS_CACHE.clear();
        FIELD_CACHE.clear();
        SETTER_CACHE.clear();
    }

    public static void clearCache(Class<?> clazz) {
        if (clazz != null) {
            CLASS_FIELDS_CACHE.remove(clazz);
            String prefix = clazz.getName() + "#";
            FIELD_CACHE.keySet().removeIf(key -> key.startsWith(prefix));
            SETTER_CACHE.keySet().removeIf(key -> key.startsWith(prefix));
        }
    }

    public static boolean isBaseType(Object arg) {
        return arg instanceof String || arg instanceof Boolean || arg instanceof Short || arg instanceof Integer || arg instanceof Long || arg instanceof Float || arg instanceof Double || arg instanceof Character;
    }

    public static Map<?, ?> cloneMap(Map<?, ?> source) {
        Map target = null;
        try {
            target = (Map)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                target.put(entry.getKey(), ClassUtils.cloneMap((Map)value));
                continue;
            }
            if (value instanceof List) {
                target.put(entry.getKey(), ClassUtils.cloneList((List)value));
                continue;
            }
            if (ClassUtils.isBaseType(value)) {
                target.put(entry.getKey(), value);
                continue;
            }
            if (value instanceof Cloneable) {
                try {
                    Method method = value.getClass().getMethod("clone", new Class[0]);
                    Object newValue = method.invoke(value, new Object[0]);
                    target.put(entry.getKey(), newValue);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object newValue = null;
            try {
                newValue = value.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
            }
            Object aa = entry.getValue();
            BeanUtils.copyProperties(value, newValue);
            target.put(entry.getKey(), newValue);
        }
        return target;
    }

    public static List<?> cloneList(List<?> source) {
        List target = null;
        try {
            target = (List)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
        }
        for (Object value : source) {
            if (value instanceof Map) {
                target.add(ClassUtils.cloneMap((Map)value));
                continue;
            }
            if (value instanceof List) {
                target.add(ClassUtils.cloneList((List)value));
                continue;
            }
            if (ClassUtils.isBaseType(value)) {
                target.add(value);
                continue;
            }
            Object newValue = null;
            try {
                newValue = value.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
            }
            BeanUtils.copyProperties(value, newValue);
            target.add(newValue);
        }
        return target;
    }

    static {
        try {
            NO_SETTER_MARKER = Object.class.getMethod("toString", new Class[0]);
        }
        catch (Exception e) {
            throw new RuntimeException("\u521d\u59cb\u5316NO_SETTER_MARKER\u5931\u8d25", e);
        }
    }
}

