/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.logger.Ulog;
import com.uniapis.utils.StrUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.springframework.beans.BeanUtils;

public class ClassUtils {
    public static void copyProperties(Object source, Object target) {
        List<Field> fields = ClassUtils.getClassFields(source.getClass());
        for (Field field : fields) {
            Object tv;
            Object sv = ClassUtils.getProperty(source, field.getName());
            if (Objects.equals(sv, tv = ClassUtils.getProperty(target, field.getName()))) continue;
            if (sv != null) {
                ClassUtils.setProperty(target, field.getName(), sv);
                continue;
            }
            ClassUtils.setProperty(target, field.getName(), null);
        }
    }

    public static void setProperty(Object data, String field, Object value) {
        Field aField = ClassUtils.getField(data, field);
        if (aField == null) {
            return;
        }
        try {
            Method method = data.getClass().getMethod("set" + StrUtils.uppFstChar(field), aField.getType());
            method.invoke(data, value);
            return;
        }
        catch (Exception e) {
            Ulog.debug((String)("\u8bbe\u7f6e\u503c\u51fa\u9519\uff1adataType[" + data.getClass().getName() + "],column[" + field + "],value[" + value + "],valueType[" + value.getClass() + "]" + e.getMessage()));
            try {
                aField.set(data, value);
            }
            catch (Exception e2) {
                try {
                    aField.set(data, StrUtils.trimStr(value));
                }
                catch (Exception e1) {
                    Ulog.warn((String)("\u8bbe\u7f6e\u503c\u51fa\u9519\uff1adataType[" + data.getClass().getName() + "],column[" + field + "],value[" + value + "],valueType[" + value.getClass() + "]" + e1.getMessage()));
                    Ulog.error((Throwable)e2);
                    Ulog.error((Throwable)e1);
                }
            }
            return;
        }
    }

    public static Object getProperty(Object arg, String field) {
        Field aField = ClassUtils.getField(arg, field);
        if (aField != null) {
            try {
                return aField.get(arg);
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return null;
    }

    public static Field getField(Object arg, String field) {
        Field aField = null;
        for (Class<?> clazz = arg.getClass(); clazz != Object.class; clazz = clazz.getSuperclass()) {
            try {
                aField = clazz.getDeclaredField(field);
            }
            catch (NoSuchFieldException noSuchFieldException) {
                // empty catch block
            }
            if (aField == null) continue;
            aField.setAccessible(true);
            return aField;
        }
        return null;
    }

    public static List<Field> getClassFields(Class<?> cla) {
        ArrayList<Field> fields = new ArrayList<Field>();
        Field[] fieldArray = cla.getDeclaredFields();
        fields.addAll(Arrays.asList(fieldArray));
        Class<?> superClass = cla.getSuperclass();
        if (superClass != Object.class) {
            fields.addAll(ClassUtils.getClassFields(superClass));
        }
        return fields;
    }

    public static Class<?> getFieldGenericity(Field field) {
        Type type = field.getGenericType();
        if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)field.getGenericType();
            Class c = (Class)pt.getActualTypeArguments()[0];
            return c;
        }
        return null;
    }

    public static boolean isBaseType(Object arg) {
        return arg instanceof String || arg instanceof Boolean || arg instanceof Short || arg instanceof Integer || arg instanceof Long || arg instanceof Float || arg instanceof Double || arg instanceof Character;
    }

    public static Map<?, ?> cloneMap(Map<?, ?> source) {
        Map target = null;
        try {
            target = (Map)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
        }
        for (Map.Entry<?, ?> entry : source.entrySet()) {
            Object value = entry.getValue();
            if (value instanceof Map) {
                target.put(entry.getKey(), ClassUtils.cloneMap((Map)value));
                continue;
            }
            if (value instanceof List) {
                target.put(entry.getKey(), ClassUtils.cloneList((List)value));
                continue;
            }
            if (ClassUtils.isBaseType(value)) {
                target.put(entry.getKey(), value);
                continue;
            }
            if (value instanceof Cloneable) {
                try {
                    Method method = value.getClass().getMethod("clone", new Class[0]);
                    Object newValue = method.invoke(value, new Object[0]);
                    target.put(entry.getKey(), newValue);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object newValue = null;
            try {
                newValue = value.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
            }
            Object aa = entry.getValue();
            BeanUtils.copyProperties(value, newValue);
            target.put(entry.getKey(), newValue);
        }
        return target;
    }

    public static List<?> cloneList(List<?> source) {
        List target = null;
        try {
            target = (List)source.getClass().newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
        }
        for (Object value : source) {
            if (value instanceof Map) {
                target.add(ClassUtils.cloneMap((Map)value));
                continue;
            }
            if (value instanceof List) {
                target.add(ClassUtils.cloneList((List)value));
                continue;
            }
            if (ClassUtils.isBaseType(value)) {
                target.add(value);
                continue;
            }
            Object newValue = null;
            try {
                newValue = value.getClass().newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("\u514b\u9686\u5bf9\u8c61\u65f6\u521b\u5efa\u65b0\u5bf9\u8c61\u5931\u8d25", e);
            }
            BeanUtils.copyProperties(value, newValue);
            target.add(newValue);
        }
        return target;
    }
}

