/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.utils.DateUtils;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class IdCard {
    private boolean effective;
    private Gender gender;
    private Date birthday;
    private double age;
    private static final Map<Integer, String> zoneNum = new HashMap<Integer, String>();
    private static final int[] PARITYBIT;
    private static final int[] POWER_LIST;

    private IdCard() {
    }

    public boolean isEffective() {
        return this.effective;
    }

    public Gender getGender() {
        return this.gender;
    }

    public Date getBirthday() {
        return this.birthday;
    }

    public double getAge() {
        return this.age;
    }

    public static IdCard isIdcard(String idCard) {
        IdCard card = new IdCard();
        if (idCard == null || idCard.length() != 15 && idCard.length() != 18) {
            card.effective = false;
            return card;
        }
        char[] cs = idCard.toUpperCase().toCharArray();
        int power = 0;
        for (int i = 0; i < cs.length && (i != cs.length - 1 || cs[i] != 'X'); ++i) {
            if (cs[i] < '0' || cs[i] > '9') {
                card.effective = false;
                return card;
            }
            if (i >= cs.length - 1) continue;
            power += (cs[i] - 48) * POWER_LIST[i];
        }
        if (!zoneNum.containsKey(Integer.valueOf(idCard.substring(0, 2)))) {
            card.effective = false;
            return card;
        }
        String year = idCard.length() == 15 ? "19" + idCard.substring(6, 8) : idCard.substring(6, 10);
        int iyear = Integer.parseInt(year);
        if (iyear < 1900 || iyear > Calendar.getInstance().get(1)) {
            card.effective = false;
            return card;
        }
        String month = idCard.length() == 15 ? idCard.substring(8, 10) : idCard.substring(10, 12);
        int imonth = Integer.parseInt(month);
        if (imonth < 1 || imonth > 12) {
            card.effective = false;
            return card;
        }
        String day = idCard.length() == 15 ? idCard.substring(10, 12) : idCard.substring(12, 14);
        int iday = Integer.parseInt(day);
        if (iday < 1 || iday > 31) {
            card.effective = false;
            return card;
        }
        if (!DateUtils.isValidDate(year + month + day)) {
            card.effective = false;
            return card;
        }
        if (idCard.length() == 15) {
            card.effective = true;
            return card;
        }
        if (cs[cs.length - 1] != PARITYBIT[power % 11]) {
            card.effective = false;
            return card;
        }
        card.effective = true;
        int serno = idCard.length() == 15 ? Integer.parseInt(idCard.substring(idCard.length() - 3, idCard.length())) : Integer.parseInt(idCard.substring(idCard.length() - 4, idCard.length() - 1));
        card.gender = serno % 2 == 0 ? Gender.F : Gender.M;
        card.birthday = DateUtils.string2Date(year + month + day);
        card.age = DateUtils.calcAge(DateUtils.sysDate());
        return card;
    }

    static boolean validate(int year, int month, int day) {
        return true;
    }

    static {
        zoneNum.put(11, "\u5317\u4eac");
        zoneNum.put(12, "\u5929\u6d25");
        zoneNum.put(13, "\u6cb3\u5317");
        zoneNum.put(14, "\u5c71\u897f");
        zoneNum.put(15, "\u5185\u8499\u53e4");
        zoneNum.put(21, "\u8fbd\u5b81");
        zoneNum.put(22, "\u5409\u6797");
        zoneNum.put(23, "\u9ed1\u9f99\u6c5f");
        zoneNum.put(31, "\u4e0a\u6d77");
        zoneNum.put(32, "\u6c5f\u82cf");
        zoneNum.put(33, "\u6d59\u6c5f");
        zoneNum.put(34, "\u5b89\u5fbd");
        zoneNum.put(35, "\u798f\u5efa");
        zoneNum.put(36, "\u6c5f\u897f");
        zoneNum.put(37, "\u5c71\u4e1c");
        zoneNum.put(41, "\u6cb3\u5357");
        zoneNum.put(42, "\u6e56\u5317");
        zoneNum.put(43, "\u6e56\u5357");
        zoneNum.put(44, "\u5e7f\u4e1c");
        zoneNum.put(45, "\u5e7f\u897f");
        zoneNum.put(46, "\u6d77\u5357");
        zoneNum.put(50, "\u91cd\u5e86");
        zoneNum.put(51, "\u56db\u5ddd");
        zoneNum.put(52, "\u8d35\u5dde");
        zoneNum.put(53, "\u4e91\u5357");
        zoneNum.put(54, "\u897f\u85cf");
        zoneNum.put(61, "\u9655\u897f");
        zoneNum.put(62, "\u7518\u8083");
        zoneNum.put(63, "\u9752\u6d77");
        zoneNum.put(64, "\u5b81\u590f");
        zoneNum.put(65, "\u65b0\u7586");
        zoneNum.put(71, "\u53f0\u6e7e");
        zoneNum.put(81, "\u9999\u6e2f");
        zoneNum.put(82, "\u6fb3\u95e8");
        zoneNum.put(91, "\u56fd\u5916");
        PARITYBIT = new int[]{49, 48, 88, 57, 56, 55, 54, 53, 52, 51, 50};
        POWER_LIST = new int[]{7, 9, 10, 5, 8, 4, 2, 1, 6, 3, 7, 9, 10, 5, 8, 4, 2};
    }

    public static enum Gender {
        F("\u5973\u6027", "F"),
        M("\u7537\u6027", "M");

        private String name = "";
        private String code = "";

        private Gender(String name, String code) {
            this.name = name;
            this.code = code;
        }

        public String getName() {
            return this.name;
        }

        public String getCode() {
            return this.code;
        }
    }
}

