/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Ulog;
import com.uniapis.utils.HttpUtilsException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.NameValuePair;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpHead;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.impl.conn.DefaultProxyRoutePlanner;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;
import org.apache.http.util.EntityUtils;

class HttpUtilBase {
    private HttpHost proxy;
    private static final String HTTPS = "https";

    HttpUtilBase() {
    }

    public Map<String, String> sendHeader(String url, Map<String, String> headers, int timeout, String defaultCharset, boolean isString) {
        HttpHead header = new HttpHead(url);
        this.initHeader(headers, timeout, (HttpRequestBase)header);
        HashMap<String, String> headerMap = new HashMap<String, String>(headers);
        this.send(url, (HttpRequestBase)header, defaultCharset, true, hds -> {
            if (hds == null) {
                return;
            }
            headerMap.putAll(Arrays.stream(hds).collect(Collectors.toMap(NameValuePair::getName, NameValuePair::getValue)));
        });
        return headerMap;
    }

    public String jsonPost(String url, String bodyJson, Map<String, String> headers, int timeout, String defaultCharset) {
        HttpPost httpPost = this.initHttpPost(url, bodyJson, headers, timeout);
        try {
            return this.send(url, (HttpRequestBase)httpPost, defaultCharset, true, null).toString();
        }
        catch (HttpUtilsException e) {
            throw new RuntimeException(e);
        }
    }

    public String formPost(String url, Map<String, ?> body, Map<String, String> headers, int timeout, String defaultCharset) {
        HashMap<String, String> bodyParam = new HashMap<String, String>();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (body != null && !body.isEmpty()) {
            for (Map.Entry<String, ?> entry : body.entrySet()) {
                String fileName;
                if (entry.getValue() instanceof String) {
                    builder.addTextBody(entry.getKey(), (String)entry.getValue());
                    bodyParam.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof File) {
                    builder.addBinaryBody(entry.getKey(), (File)entry.getValue());
                    bodyParam.put(entry.getKey(), "File " + ((File)entry.getValue()).getPath());
                    continue;
                }
                if (entry.getValue() instanceof byte[] || entry.getValue() instanceof Byte[]) {
                    fileName = this.checkFileName(body, entry);
                    builder.addBinaryBody(entry.getKey(), (byte[])entry.getValue(), ContentType.DEFAULT_BINARY, fileName);
                    bodyParam.put(entry.getKey(), "byte[]");
                    continue;
                }
                if (!(entry.getValue() instanceof InputStream)) continue;
                fileName = this.checkFileName(body, entry);
                builder.addBinaryBody(entry.getKey(), (InputStream)entry.getValue(), ContentType.DEFAULT_BINARY, fileName);
                bodyParam.put(entry.getKey(), "InputStream");
            }
        }
        this.logParam(url, JsonUtils.toJson(bodyParam), headers);
        HttpPost httpPost = new HttpPost(url);
        this.initHeader(headers, timeout, (HttpRequestBase)httpPost);
        httpPost.setEntity(builder.build());
        try {
            return this.send(url, (HttpRequestBase)httpPost, defaultCharset, true, null).toString();
        }
        catch (HttpUtilsException e) {
            throw new RuntimeException(e);
        }
    }

    private String checkFileName(Map<String, ?> body, Map.Entry<String, ?> entry) {
        String fileName = StrUtils.trimStr(body.get(entry.getKey() + "_name"));
        if (StrUtils.isNull(fileName)) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u79f0[" + entry.getKey() + "_name]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return fileName;
    }

    public byte[] binaryPost(String url, String bodyJson, Map<String, String> headers, int timeout, String defaultCharset) throws HttpUtilsException {
        HttpPost httpPost = this.initHttpPost(url, bodyJson, headers, timeout);
        return (byte[])this.send(url, (HttpRequestBase)httpPost, defaultCharset, false, null);
    }

    private HttpPost initHttpPost(String url, String bodyJson, Map<String, String> headers, int timeout) {
        this.logParam(url, bodyJson, headers);
        HttpPost httpPost = new HttpPost(url);
        this.initHeader(headers, timeout, (HttpRequestBase)httpPost);
        StringEntity stringEntity = null;
        try {
            stringEntity = new StringEntity(bodyJson, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        stringEntity.setContentType("application/json; charset=utf-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private HttpGet initHttpGet(String url, Map<String, String> headers, int timeout) {
        HttpGet httpGet = new HttpGet(url);
        this.logParam(url, null, headers);
        this.initHeader(headers, timeout, (HttpRequestBase)httpGet);
        return httpGet;
    }

    private Object send(String url, HttpRequestBase httpPost, String defaultCharset, boolean isString, Consumer<Header[]> headerCb) throws HttpUtilsException {
        long start = System.currentTimeMillis();
        try {
            if (this.isHttps(url)) {
                try {
                    Object object = this.sendHttps(httpPost, defaultCharset, isString, headerCb);
                    return object;
                }
                catch (HttpUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object e = this.baseHttp(httpPost, defaultCharset, true, null, headerCb);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            Ulog.info((String)("\u8c03\u7528\u7ed3\u675f[" + (double)(System.currentTimeMillis() - start) / 1000.0 + "]\u79d2"));
        }
    }

    public Object sendGet(String url, Map<String, String> headers, int timeout, String defaultCharset, boolean isString) {
        HttpGet httpGet = this.initHttpGet(url, headers, timeout);
        return this.send(url, (HttpRequestBase)httpGet, defaultCharset, isString, null);
    }

    private Object sendHttps(HttpRequestBase http, String defaultCharset, boolean isString, Consumer<Header[]> headerCb) {
        SSLContext sslcontext = this.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register(HTTPS, (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        try (PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);){
            Object object = this.baseHttp(http, defaultCharset, isString, (HttpClientConnectionManager)connManager, headerCb);
            return object;
        }
    }

    public SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return sc;
    }

    private Object sendHttp(HttpRequestBase http, String defaultCharset, boolean isString, Consumer<Header[]> headerCb) {
        return this.baseHttp(http, defaultCharset, isString, null, headerCb);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Object baseHttp(HttpRequestBase http, String defaultCharset, boolean isString, HttpClientConnectionManager connManager, Consumer<Header[]> headerCb) {
        HttpClientBuilder builder = HttpClients.custom();
        if (connManager != null) {
            builder.setConnectionManager(connManager);
        }
        if (this.proxy != null) {
            builder.setRoutePlanner((HttpRoutePlanner)new DefaultProxyRoutePlanner(this.proxy));
        }
        try (CloseableHttpClient httpClient = builder.build();){
            Object object;
            block19: {
                CloseableHttpResponse response = httpClient.execute((HttpUriRequest)http);
                try {
                    if (headerCb != null) {
                        headerCb.accept(response.getAllHeaders());
                    }
                    HttpEntity entity = response.getEntity();
                    Object body = new Object();
                    if (entity != null) {
                        body = entity.getContentType() == null || entity.getContentType().getValue() == null || entity.getContentType().getValue().contains("text") || entity.getContentType().getValue().contains("json") || entity.getContentType().getValue().contains("xml") ? EntityUtils.toString((HttpEntity)entity, (String)defaultCharset) : (Object)EntityUtils.toByteArray((HttpEntity)entity);
                    }
                    Ulog.info((String)("\u8fd4\u56de\u62a5\u6587\uff1a" + body));
                    EntityUtils.consume((HttpEntity)entity);
                    if (!isString && body instanceof String) {
                        throw new HttpUtilsException(body.toString());
                    }
                    object = body;
                    if (response == null) break block19;
                }
                catch (Throwable throwable) {
                    if (response != null) {
                        try {
                            response.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                response.close();
            }
            return object;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void initHeader(Map<String, String> headers, int timeout, HttpRequestBase httpBase) {
        String mainThread;
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
        if (StrUtils.isNull(mainThread = ThreadLocalContext.get().getMainThread())) {
            mainThread = ThreadLocalContext.get().getThreadUUID();
        }
        httpBase.setHeader("mainThread", mainThread);
        httpBase.setConfig(RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build());
    }

    private void logParam(String url, String bodyJson, Map<String, String> headers) {
        Ulog.info((String)("\u5f00\u59cb\u8c03\u7528[" + url + "]"));
        if (bodyJson != null) {
            Ulog.info((String)("\u8bf7\u6c42\u53c2\u6570\uff1a" + bodyJson));
        }
        Ulog.info((String)("\u8bf7\u6c42\u5934\u4fe1\u606f\uff1a" + JsonUtils.toJson(headers)));
    }

    private boolean isHttps(String url) {
        return StrUtils.trimStr(url).toLowerCase().startsWith(HTTPS);
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public HttpUtilBase setProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }
}

