/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.logger.Ulog;
import com.uniapis.utils.HttpUtilsException;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import org.springframework.util.ResourceUtils;

class FileReadUtils {
    FileReadUtils() {
    }

    public static List<String> readJarFile(String path) {
        ArrayList<String> textFile = new ArrayList<String>();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        try (InputStream in = ResourceUtils.class.getClassLoader().getResourceAsStream(path);
             BufferedReader br = new BufferedReader(new InputStreamReader(in));){
            String line;
            while ((line = br.readLine()) != null) {
                textFile.add(line);
            }
        }
        catch (Exception e) {
            Ulog.info((String)("readJarFile path = " + path));
            Ulog.error((Throwable)e);
        }
        return textFile;
    }

    public static List<String> readLocalFile(String path) {
        return FileReadUtils.readLocalFile(path, s -> s);
    }

    public static <T> List<T> readLocalFile(String path, Function<String, T> func) {
        ArrayList<T> list = new ArrayList<T>();
        if (!new File(path).exists()) {
            return list;
        }
        try (FileInputStream fin2 = new FileInputStream(path);
             InputStreamReader reader = new InputStreamReader(fin2);
             BufferedReader br = new BufferedReader(reader);){
            String line;
            while ((line = br.readLine()) != null) {
                list.add(func.apply(line));
            }
        }
        catch (HttpUtilsException fin2) {
        }
        catch (Exception e) {
            Ulog.info((String)("readLocalFile path = " + path));
            Ulog.error((Throwable)e);
        }
        return list;
    }
}

