/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveOutputStream;
import org.apache.commons.compress.utils.IOUtils;

class Zip {
    private static final int BUFFER_SIZE = 1024;

    Zip() {
    }

    public static void unzip(InputStream source, String target) {
        try (ZipArchiveInputStream inputStream = new ZipArchiveInputStream(source);){
            ArchiveEntry archiveEntry = null;
            while ((archiveEntry = inputStream.getNextEntry()) != null) {
                File entryFile = new File(target, archiveEntry.getName());
                if (archiveEntry.isDirectory()) {
                    if (entryFile.exists()) continue;
                    entryFile.mkdirs();
                    continue;
                }
                if (!entryFile.getParentFile().exists()) {
                    entryFile.getParentFile().mkdirs();
                }
                try (FileOutputStream os = new FileOutputStream(entryFile);){
                    IOUtils.copy((InputStream)inputStream, (OutputStream)os);
                    os.flush();
                }
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public static void unzip(String source, String target) {
        File file = new File(source);
        try (FileInputStream inputStream = new FileInputStream(file);){
            Zip.unzip(inputStream, target);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static void zip(String source, String target, String[] exts) {
        String regexp = ".*(" + Arrays.asList(exts).stream().collect(Collectors.joining("|")) + ")$";
        Pattern pattern = Pattern.compile(regexp);
        File sourceFile = new File(source);
        List<File> files = Zip.findFiles(sourceFile, pattern);
        File zipFile = new File(target);
        try (ZipArchiveOutputStream stream = new ZipArchiveOutputStream(zipFile);){
            for (File file : files) {
                try (FileInputStream in = new FileInputStream(file);){
                    ZipArchiveEntry entry = new ZipArchiveEntry(file, file.getAbsolutePath().substring(sourceFile.getPath().length() + 1));
                    stream.putArchiveEntry((ArchiveEntry)entry);
                    IOUtils.copy((InputStream)in, (OutputStream)stream);
                    stream.closeArchiveEntry();
                }
            }
            stream.finish();
        }
        catch (Exception e) {
            throw new RuntimeException("\u538b\u7f29\u6587\u4ef6\u51fa\u9519", e);
        }
    }

    private static List<File> findFiles(File path, Pattern pattern) {
        ArrayList<File> files = new ArrayList<File>();
        if (path.isDirectory()) {
            File[] fileList;
            for (File aFile : fileList = path.listFiles()) {
                if (aFile.isDirectory()) {
                    files.addAll(Zip.findFiles(aFile, pattern));
                    continue;
                }
                if (!pattern.matcher(aFile.getName()).matches()) continue;
                files.add(aFile);
            }
        } else if (pattern.matcher(path.getName()).matches()) {
            files.add(path);
        }
        return files;
    }

    public static void main(String[] args) throws Exception {
        Zip.zip("/uniapis/logs", "/uniapis/logs/log.zip", new String[0]);
        Zip.unzip("/Users/admin/Downloads/1576036167585.1576036177962.zip", "/Users/admin/Downloads/1576036167585.1576036177962");
    }
}

