/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.utils.JsonUtils;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class MapUtils {
    private static final Pattern TOKEN_PATTERN = Pattern.compile("[^.\\[\\]]+|\\[(\\d+)]");

    public static <T> T get(Map<?, ?> map, Class<T> type, T defValue, String ... keys) {
        keys = MapUtils.parsePath(keys);
        Map<Object, Object> current = map;
        for (String key : keys) {
            int idx;
            if (current == null) {
                return defValue;
            }
            if (current instanceof Map) {
                current = current.get(key);
                continue;
            }
            if (!(current instanceof List)) continue;
            try {
                idx = Integer.parseInt(key.toString());
            }
            catch (Exception e) {
                return defValue;
            }
            List list = (List)((Object)current);
            if (list == null || list.isEmpty() || list.size() <= idx) {
                return defValue;
            }
            current = list.get(idx);
        }
        return type.isInstance(current) ? type.cast(current) : defValue;
    }

    public static String str(Map<?, ?> map, String ... keys) {
        return MapUtils.get(map, String.class, "", keys);
    }

    public static Integer integer(Map<?, ?> map, String ... keys) {
        return MapUtils.get(map, Integer.class, 0, keys);
    }

    public static Integer integer(Map<?, ?> map, int defValue, String ... keys) {
        return MapUtils.get(map, Integer.class, defValue, keys);
    }

    public static Double doubled(Map<?, ?> map, String ... keys) {
        return MapUtils.get(map, Double.class, 0.0, keys);
    }

    public static Double doubled(Map<?, ?> map, double defValue, String ... keys) {
        return MapUtils.get(map, Double.class, defValue, keys);
    }

    public static Boolean bool(Map<?, ?> map, String ... keys) {
        return MapUtils.get(map, Boolean.class, false, keys);
    }

    public static Boolean bool(Map<?, ?> map, boolean defValue, String ... keys) {
        return MapUtils.get(map, Boolean.class, defValue, keys);
    }

    public static String[] parsePath(String ... keys) {
        ArrayList<String> list = new ArrayList<String>();
        for (String key : keys) {
            Matcher matcher = TOKEN_PATTERN.matcher(key);
            if (!matcher.find()) {
                list.add(key);
                continue;
            }
            matcher.reset();
            while (matcher.find()) {
                if (matcher.group(1) != null) {
                    list.add(matcher.group(1));
                    continue;
                }
                list.add(matcher.group());
            }
        }
        return list.toArray(new String[0]);
    }

    public static void main(String[] args) {
        String path = "data.outputs[0].result";
        String[] parsed = MapUtils.parsePath(path, "items[3].meta.title");
        System.out.println(JsonUtils.toJson(parsed));
    }
}

