/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.utils.DateUtils;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class StrUtils {
    private static final String H_SYMBOL = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ0123456789!\"#$%&'()*+,./:;<=>?@[\\]^_`{|}-~ ";
    private static final String Z_SYMBOL = "\uff41\uff42\uff43\uff44\uff45\uff46\uff47\uff48\uff49\uff4a\uff4b\uff4c\uff4d\uff4e\uff4f\uff50\uff51\uff52\uff53\uff54\uff55\uff56\uff57\uff58\uff59\uff5a\uff21\uff22\uff23\uff25\uff25\uff26\uff27\uff28\uff29\uff2a\uff2b\uff2c\uff2d\uff2e\uff2f\uff30\uff31\uff32\uff33\uff34\uff35\uff36\uff37\uff38\uff39\uff3a\uff10\uff11\uff12\uff13\uff14\uff15\uff16\uff17\uff18\uff19\uff01\u201d\uff03\uff04\uff05\uff06\u2019\uff08\uff09\uff0a\uff0b\uff0c\uff0e\uff0f\uff1a\uff1b\uff1c\uff1d\uff1e\uff1f\uff20\uff3b\uffe5\uff3d\uff3e\uff3f\u2018\uff5b\uff5c\uff5d\uff0d\uff5e\u3000";
    private static final char E = 'e';

    public static String joinString(List<Map<String, Object>> list, String key) {
        String deptListString = "";
        if (list != null && !list.isEmpty()) {
            for (Map<String, Object> oneDept : list) {
                deptListString = deptListString + "'" + (String)oneDept.get(key) + "',";
            }
            if (deptListString != null && !"".equals(deptListString)) {
                deptListString = deptListString.substring(1, deptListString.length() - 2);
            }
        }
        return deptListString;
    }

    public static String joinString(List<String> list) {
        String deptListString = "";
        if (list != null && !list.isEmpty()) {
            for (String s : list) {
                deptListString = deptListString + "'" + s + "',";
            }
            if (deptListString != null && !"".equals(deptListString)) {
                deptListString = deptListString.substring(1, deptListString.length() - 2);
            }
        }
        return deptListString;
    }

    public static String joinString(String[] list) {
        String deptListString = "";
        if (list != null && list.length != 0) {
            for (String s : list) {
                deptListString = deptListString + "'" + s + "',";
            }
            if (deptListString != null && !"".equals(deptListString)) {
                deptListString = deptListString.substring(1, deptListString.length() - 2);
            }
        }
        return deptListString;
    }

    public static String alignLeft(Object string, int maxLength, String appendString) {
        int len = StrUtils.getBytesLength(StrUtils.trimStr(string));
        if (len <= maxLength) {
            String appended = "";
            int appendCount = maxLength - len;
            for (int i = 0; i < appendCount; ++i) {
                appended = appended + appendString;
            }
            return appended + string;
        }
        throw new RuntimeException("\u5b57\u7b26\u4e32[" + string + "]\u957f\u5ea6\u8d85\u51fa\u6700\u5927\u957f\u5ea6[" + maxLength + "]");
    }

    public static String alignLeft(Object string, int maxLength) {
        return StrUtils.alignLeft(string, maxLength, "0");
    }

    public static String alignRight(Object string, int maxLength, String appendString) {
        int len = StrUtils.getBytesLength(StrUtils.trimStr(string));
        StringBuilder buffer = new StringBuilder();
        buffer.append(string);
        if (len <= maxLength) {
            int appendCount = maxLength - len;
            for (int i = 0; i < appendCount; ++i) {
                buffer.append(appendString);
            }
        } else {
            throw new RuntimeException("\u5b57\u7b26\u4e32[" + string + "]\u957f\u5ea6\u8d85\u51fa\u6700\u5927\u957f\u5ea6[" + maxLength + "]");
        }
        if (buffer.substring(buffer.length() - 1).getBytes().length >= 2) {
            throw new RuntimeException("\u5b57\u7b26\u4e32[" + string + "]\u4e0d\u80fd\u4ee5\u6c49\u5b57\u7ed3\u5c3e\u3002");
        }
        return buffer.toString();
    }

    public static String alignRight(Object string, int maxLength) {
        return StrUtils.alignRight(string, maxLength, " ");
    }

    public static String alignDecimal(Object num, int befDecimal, int aftDecimal) {
        String pointBef = "";
        String pointAft = "";
        Double.parseDouble(StrUtils.trimStr(num));
        String[] decimal = StrUtils.trimStr(num).split("\\.");
        pointBef = StrUtils.alignLeft(decimal[0], befDecimal);
        pointAft = decimal.length >= 2 ? StrUtils.alignRight(decimal[1], aftDecimal, "0") : StrUtils.alignRight("", aftDecimal, "0");
        return pointBef + "." + pointAft;
    }

    public static int getBytesLength(String str) {
        if (str == null || "".equals(str)) {
            return 0;
        }
        int hanZiChuan = 0;
        boolean hanZiFlag = false;
        char[] arr = str.toCharArray();
        for (int i = 0; i < arr.length; ++i) {
            if (String.valueOf(arr[i]).getBytes().length >= 2) {
                if (!hanZiFlag) {
                    ++hanZiChuan;
                }
                hanZiFlag = true;
                continue;
            }
            if (!hanZiFlag) continue;
            hanZiFlag = false;
        }
        return str.getBytes().length + hanZiChuan * 2;
    }

    public static List<String> array2List(String[] array) {
        ArrayList<String> list = new ArrayList<String>();
        for (String s : array) {
            if (s == null) continue;
            list.add(s.trim());
        }
        return list;
    }

    public static String toSBC(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String tmp = str;
        for (int i = 0; i < H_SYMBOL.length(); ++i) {
            tmp = tmp.replace(H_SYMBOL.charAt(i), Z_SYMBOL.charAt(i));
        }
        StringBuilder sb = new StringBuilder(tmp);
        return sb.toString();
    }

    public static String toDBC(String str) {
        if (str == null || str.length() == 0) {
            return "";
        }
        String tmp = str;
        for (int i = 0; i < Z_SYMBOL.length(); ++i) {
            tmp = tmp.replace(Z_SYMBOL.charAt(i), H_SYMBOL.charAt(i));
        }
        StringBuilder sb = new StringBuilder(tmp);
        return sb.toString();
    }

    public static boolean isNull(Object content) {
        return content == null || "".equals(StrUtils.trimStr(content)) || "null".equals(StrUtils.trimStr(content));
    }

    public static String trimStr(Object str) {
        if (str == null || "".equals(str) || "NULL".equals(str.toString().toUpperCase())) {
            return "";
        }
        if (str instanceof String) {
            return str.toString().trim();
        }
        if (str instanceof Timestamp) {
            return DateUtils.date2String((Date)str, "yyyy-MM-dd HH:mm:ss");
        }
        if (str instanceof Date) {
            return DateUtils.date2String((Date)str);
        }
        return str.toString().trim();
    }

    public static String lowFstChar(Object obj) {
        if (obj == null) {
            return "";
        }
        String arg = obj.toString();
        if ("".equals(arg)) {
            return "";
        }
        if (arg.length() == 1) {
            return arg.toLowerCase();
        }
        return arg.substring(0, 1).toLowerCase() + arg.substring(1, arg.length());
    }

    public static String uppFstChar(Object obj) {
        if (obj == null) {
            return "";
        }
        String arg = obj.toString();
        if ("".equals(arg)) {
            return "";
        }
        if (arg.length() == 1) {
            return arg.toUpperCase();
        }
        return arg.substring(0, 1).toUpperCase() + arg.substring(1, arg.length());
    }

    public static boolean isNum(Object o) {
        if (StrUtils.isNull(o)) {
            return false;
        }
        String s = o.toString();
        if (s.length() > 1 && s.toLowerCase().charAt(s.length() - 1) == 'e') {
            try {
                s = StrUtils.doubleTo(o);
            }
            catch (Exception e) {
                return false;
            }
        }
        String regex = "^[1-9][0-9]*\\.[0-9]+$|^[1-9][0-9]*$|^0+\\.[0-9]+$|^[0-9]{1}$";
        Pattern pattern = Pattern.compile(regex);
        char c = s.charAt(0);
        if (c == '+' || c == '-') {
            s = s.substring(1);
        }
        Matcher matcher = pattern.matcher(s);
        return matcher.matches();
    }

    public static String doubleTo(Object value) {
        DecimalFormat decimalFormat = new DecimalFormat("###0.000000");
        return decimalFormat.format(value);
    }

    public static void append(StringBuilder sb, String ... args) {
        for (String s : args) {
            sb.append(s);
        }
    }

    public static StringBuilder append(String ... args) {
        StringBuilder sb = new StringBuilder();
        for (String s : args) {
            sb.append(s);
        }
        return sb;
    }

    public static boolean endsWith(StringBuilder sb, String with) {
        if (sb == null || with == null) {
            return false;
        }
        return sb.lastIndexOf(with) == sb.length() - with.length();
    }
}

