/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.logger.Env;

class SnowflakeId {
    private static final long START_TIMESTAMP = 1622808000000L;
    private static final long SEQUENCE_BIT = 12L;
    private static final long MACHINE_BIT = 10L;
    private static final long TIMESTAMP_BIT = 41L;
    private static final long MAX_SEQUENCE_NUM = 4095L;
    private static final long MAX_MACHINE_NUM = 1023L;
    private static final long TIMESTAMP_LEFT_SHIFT = 22L;
    private static final long MACHINE_LEFT_SHIFT = 12L;
    private long sequence = 0L;
    private long machineId = 0L;
    private long lastTimestamp = -1L;
    private static volatile SnowflakeId snowObj = null;

    private SnowflakeId(long machineId) {
        if (machineId > 1023L || machineId < 0L) {
            throw new IllegalArgumentException("Invalid machine id");
        }
        this.machineId = machineId;
    }

    public synchronized long generateId() {
        long currentTimestamp = System.currentTimeMillis();
        if (currentTimestamp < this.lastTimestamp) {
            throw new RuntimeException("Clock moved backwards");
        }
        if (currentTimestamp == this.lastTimestamp) {
            this.sequence = this.sequence + 1L & 0xFFFL;
            if (this.sequence == 0L) {
                currentTimestamp = this.nextMillis();
            }
        } else {
            this.sequence = 0L;
        }
        this.lastTimestamp = currentTimestamp;
        return currentTimestamp - 1622808000000L << 22 | this.machineId << 12 | this.sequence;
    }

    private long nextMillis() {
        long currentTimestamp = System.currentTimeMillis();
        while (currentTimestamp <= this.lastTimestamp) {
            currentTimestamp = System.currentTimeMillis();
        }
        return currentTimestamp;
    }

    public static SnowflakeId n() {
        return SnowflakeId.n(Long.parseLong(Env.env().machineId()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static SnowflakeId n(long machineId) {
        if (snowObj != null) return snowObj;
        Class<SnowflakeId> clazz = SnowflakeId.class;
        synchronized (SnowflakeId.class) {
            if (snowObj != null) return snowObj;
            snowObj = new SnowflakeId(machineId);
            // ** MonitorExit[var2_1] (shouldn't be in output)
            return snowObj;
        }
    }
}

