/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.ser.FilterProvider;
import com.fasterxml.jackson.databind.ser.impl.SimpleBeanPropertyFilter;
import com.fasterxml.jackson.databind.ser.impl.SimpleFilterProvider;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UniApisJsonFilter;
import java.io.IOException;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class JsonUtils {
    private static final Pattern NUM_STR = Pattern.compile("(\\d,\")|(\":\\d)|(\\d})");

    public static <T> T json2Class(String json, Class<T> requiredType) {
        return JsonUtils.json2Class(json, requiredType, true);
    }

    public static <T> T json2Class(String json, Class<T> requiredType, boolean isFormatTimestamps) {
        ObjectMapper mapper = JsonUtils.initObjectMapper(isFormatTimestamps);
        try {
            return (T)mapper.readValue(json, requiredType);
        }
        catch (IOException e) {
            Ulog.error((String)json);
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> json2Map(String json) {
        if (StrUtils.isNull(json)) {
            return new HashMap<String, Object>();
        }
        try {
            ObjectMapper mapper = JsonUtils.initObjectMapper();
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
        }
        catch (Exception e) {
            Ulog.error((String)json);
            throw new RuntimeException(e);
        }
    }

    public static <T> List<T> json2List(String json, Class<T> requiredType) {
        ObjectMapper mapper = JsonUtils.initObjectMapper();
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, requiredType));
        }
        catch (Exception e) {
            Ulog.error((String)json);
            throw new RuntimeException(e);
        }
    }

    public static List<Map<String, Object>> json2List(String json) {
        ObjectMapper mapper = JsonUtils.initObjectMapper();
        try {
            return (List)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructCollectionType(ArrayList.class, Map.class));
        }
        catch (JsonProcessingException e) {
            Ulog.error((String)json);
            throw new RuntimeException("json\u8f6c\u6362\u5f02\u5e38\uff0c\u4f20\u5165json:" + json, e);
        }
    }

    public static <T> List<T> listMap2ListClass(List<?> list, Class<T> requiredType) {
        return JsonUtils.json2List(JsonUtils.toJson(list), requiredType);
    }

    public static <T> T map2Class(Map<String, Object> map, Class<T> requiredType) {
        String mapString = JsonUtils.toJson(map);
        return JsonUtils.json2Class(mapString, requiredType);
    }

    public static String toJson(Object object) {
        if (object == null) {
            return "";
        }
        try {
            ObjectMapper mapper = JsonUtils.initObjectMapper();
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static String toJson(Object object, String ... excludes) {
        UniApisJsonFilter filter = new UniApisJsonFilter();
        filter.addBaseExcludes(excludes);
        return JsonUtils.toJson(object, filter);
    }

    public static String toJson(Object object, UniApisJsonFilter filter) {
        if (object == null) {
            return "";
        }
        try {
            SimpleFilterProvider filterProvider = new SimpleFilterProvider().addFilter("UniApisJsonFilter", (SimpleBeanPropertyFilter)filter);
            ObjectMapper mapper = JsonUtils.initObjectMapper();
            Class<?> clazz = object.getClass();
            if (object instanceof List) {
                List list = (List)object;
                if (list.isEmpty()) {
                    return "";
                }
                clazz = list.get(0).getClass();
            }
            filter.getApplyClass().forEach(c -> mapper.addMixIn(c, UniApisJsonFilter.class));
            mapper.addMixIn(clazz, UniApisJsonFilter.class);
            mapper.setFilterProvider((FilterProvider)filterProvider);
            return mapper.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static void main(String[] args) {
    }

    public static void main3(String[] args) {
        User user = new User();
        ArrayList users = new ArrayList();
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("pkUuid", "123");
        map.put("pkUuid123", 123);
        String user_str = JsonUtils.toJson(user);
        String mapJson = JsonUtils.toJson(map);
        mapJson = mapJson.substring(0, mapJson.length() - 1) + ", \"user\":" + user_str + "}";
        System.out.println(mapJson);
        System.out.println(JsonUtils.toJson(map));
        users.add(map);
        System.out.println(JsonUtils.toJson(users, "pkUuid"));
    }

    public static ObjectMapper initObjectMapper() {
        return JsonUtils.initObjectMapper(true);
    }

    public static ObjectMapper initObjectMapper(boolean isFormatTimestamps) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(JsonParser.Feature.ALLOW_UNQUOTED_CONTROL_CHARS, true);
        mapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_ARRAY_AS_NULL_OBJECT, true);
        mapper.configure(JsonParser.Feature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER, true);
        mapper.setTimeZone(TimeZone.getDefault());
        if (isFormatTimestamps) {
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mapper.setDateFormat((DateFormat)d);
        }
        mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object arg0, JsonGenerator arg1, SerializerProvider arg2) throws IOException, JsonProcessingException {
                arg1.writeString("");
            }
        });
        return mapper;
    }

    public static String jsonNum2Str(String json) {
        json = json.replaceAll("\"\\s*,\\s*\"", "\",\"").replaceAll("\\s*,\\s*\"", ",\"").replaceAll("\"\\s*:\\s*", "\":").replaceAll("\\s*}", "}");
        json = JsonUtils.num2Str(json);
        json = JsonUtils.num2Str(json);
        return json;
    }

    private static String num2Str(String json) {
        Matcher m = NUM_STR.matcher(json);
        int lastIndex = 0;
        ArrayList<String> list = new ArrayList<String>();
        while (m.find()) {
            list.add(json.substring(lastIndex, m.start()));
            list.add(m.group().replace(",", "\",").replace(":", ":\"").replace("}", "\"}"));
            lastIndex = m.start() + m.group().length();
        }
        if (lastIndex != 0 && lastIndex < json.length()) {
            list.add(json.substring(lastIndex));
        }
        if (list.isEmpty()) {
            return json;
        }
        return StrUtils.append(list.toArray(new String[0])).toString();
    }

    public static void main2(String[] args) {
        String json = "{\"error\":\"{\\\"test\\\":\\\"te\\\u65f6st\\\"}\"}";
        System.out.println(json);
        System.out.println(JsonUtils.json2Map(json).get("error"));
    }

    public void main1(String[] args) {
        HashMap<String, String> test = new HashMap<String, String>();
        test.put("null", null);
        test.put("space", "");
        System.out.println(JsonUtils.toJson(test));
    }
}

