/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.RequestLog;
import com.uniapis.utils.HttpUtilsException;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.InputStream;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpRequestBase;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.entity.mime.MultipartEntityBuilder;
import org.apache.http.impl.conn.PoolingHttpClientConnectionManager;

class HttpUtilBase {
    private HttpHost proxy;
    private static final String HTTPS = "https";

    HttpUtilBase() {
    }

    public String jsonPost(String url, String bodyJson, Map<String, String> headers, int timeout, String defaultCharset) {
        HttpPost httpPost = this.initHttpOst(url, bodyJson, headers, timeout);
        try {
            return this.sendPost(url, httpPost, defaultCharset, true).toString();
        }
        catch (HttpUtilsException e) {
            throw new RuntimeException(e);
        }
    }

    public String formPost(String url, Map<String, ?> body, Map<String, String> headers, int timeout, String defaultCharset) {
        HashMap<String, String> bodyParam = new HashMap<String, String>();
        MultipartEntityBuilder builder = MultipartEntityBuilder.create();
        if (body != null && !body.isEmpty()) {
            for (Map.Entry<String, ?> entry : body.entrySet()) {
                String fileName;
                if (entry.getValue() instanceof String) {
                    builder.addTextBody(entry.getKey(), (String)entry.getValue());
                    bodyParam.put(entry.getKey(), (String)entry.getValue());
                    continue;
                }
                if (entry.getValue() instanceof File) {
                    builder.addBinaryBody(entry.getKey(), (File)entry.getValue());
                    bodyParam.put(entry.getKey(), "File " + ((File)entry.getValue()).getPath());
                    continue;
                }
                if (entry.getValue() instanceof byte[] || entry.getValue() instanceof Byte[]) {
                    fileName = this.checkFileName(body, entry);
                    builder.addBinaryBody(entry.getKey(), (byte[])entry.getValue(), ContentType.DEFAULT_BINARY, fileName);
                    bodyParam.put(entry.getKey(), "byte[]");
                    continue;
                }
                if (!(entry.getValue() instanceof InputStream)) continue;
                fileName = this.checkFileName(body, entry);
                builder.addBinaryBody(entry.getKey(), (InputStream)entry.getValue(), ContentType.DEFAULT_BINARY, fileName);
                bodyParam.put(entry.getKey(), "InputStream");
            }
        }
        this.logParam(url, JsonUtils.toJson(bodyParam), headers);
        HttpPost httpPost = new HttpPost(url);
        this.initHeader(headers, timeout, (HttpRequestBase)httpPost);
        httpPost.setEntity(builder.build());
        try {
            return this.sendPost(url, httpPost, defaultCharset, true).toString();
        }
        catch (HttpUtilsException e) {
            throw new RuntimeException(e);
        }
    }

    private String checkFileName(Map<String, ?> body, Map.Entry<String, ?> entry) {
        String fileName = StrUtils.trimStr(body.get(entry.getKey() + "_name"));
        if (StrUtils.isNull(fileName)) {
            throw new RuntimeException("\u6587\u4ef6\u540d\u79f0[" + entry.getKey() + "_name]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        return fileName;
    }

    public byte[] binaryPost(String url, String bodyJson, Map<String, String> headers, int timeout, String defaultCharset) throws HttpUtilsException {
        HttpPost httpPost = this.initHttpOst(url, bodyJson, headers, timeout);
        return (byte[])this.sendPost(url, httpPost, defaultCharset, false);
    }

    private HttpPost initHttpOst(String url, String bodyJson, Map<String, String> headers, int timeout) {
        this.logParam(url, bodyJson, headers);
        HttpPost httpPost = new HttpPost(url);
        this.initHeader(headers, timeout, (HttpRequestBase)httpPost);
        StringEntity stringEntity = null;
        try {
            stringEntity = new StringEntity(bodyJson, "UTF-8");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        stringEntity.setContentType("application/json; charset=utf-8");
        httpPost.setEntity((HttpEntity)stringEntity);
        return httpPost;
    }

    private Object sendPost(String url, HttpPost httpPost, String defaultCharset, boolean isString) throws HttpUtilsException {
        long start = System.currentTimeMillis();
        try {
            if (this.isHttps(url)) {
                try {
                    Object object = this.sendHttps((HttpRequestBase)httpPost, defaultCharset, isString);
                    return object;
                }
                catch (HttpUtilsException e) {
                    throw e;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object e = this.baseHttp((HttpRequestBase)httpPost, defaultCharset, true, null);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            RequestLog.info((String)("\u8c03\u7528\u7ed3\u675f[" + (double)(System.currentTimeMillis() - start) / 1000.0 + "]\u79d2"));
        }
    }

    public Object sendGet(String url, Map<String, String> headers, int timeout, String defaultCharset, boolean isString) {
        HttpGet httpGet = new HttpGet(url);
        this.logParam(url, null, headers);
        this.initHeader(headers, timeout, (HttpRequestBase)httpGet);
        long start = System.currentTimeMillis();
        try {
            if (this.isHttps(url)) {
                try {
                    Object object = this.sendHttps((HttpRequestBase)httpGet, defaultCharset, isString);
                    return object;
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
            Object e = this.sendHttp((HttpRequestBase)httpGet, defaultCharset, isString);
            return e;
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            RequestLog.info((String)("\u8c03\u7528\u7ed3\u675f[" + (double)(System.currentTimeMillis() - start) / 1000.0 + "]\u79d2"));
        }
    }

    private Object sendHttps(HttpRequestBase http, String defaultCharset, boolean isString) {
        SSLContext sslcontext = this.createIgnoreVerifySSL();
        Registry socketFactoryRegistry = RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.INSTANCE).register(HTTPS, (Object)new SSLConnectionSocketFactory(sslcontext)).build();
        try (PoolingHttpClientConnectionManager connManager = new PoolingHttpClientConnectionManager(socketFactoryRegistry);){
            Object object = this.baseHttp(http, defaultCharset, isString, (HttpClientConnectionManager)connManager);
            return object;
        }
    }

    public SSLContext createIgnoreVerifySSL() {
        SSLContext sc = null;
        try {
            sc = SSLContext.getInstance("SSL");
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
        X509TrustManager trustManager = new X509TrustManager(){

            @Override
            public void checkClientTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public void checkServerTrusted(X509Certificate[] paramArrayOfX509Certificate, String paramString) throws CertificateException {
            }

            @Override
            public X509Certificate[] getAcceptedIssuers() {
                return null;
            }
        };
        try {
            sc.init(null, new TrustManager[]{trustManager}, null);
        }
        catch (KeyManagementException e) {
            throw new RuntimeException(e);
        }
        return sc;
    }

    private Object sendHttp(HttpRequestBase http, String defaultCharset, boolean isString) {
        return this.baseHttp(http, defaultCharset, isString, null);
    }

    /*
     * Exception decompiling
     */
    private Object baseHttp(HttpRequestBase http, String defaultCharset, boolean isString, HttpClientConnectionManager connManager) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void initHeader(Map<String, String> headers, int timeout, HttpRequestBase httpBase) {
        if (headers != null && !headers.isEmpty()) {
            for (Map.Entry<String, String> entry : headers.entrySet()) {
                httpBase.setHeader(entry.getKey(), entry.getValue());
            }
        }
        httpBase.setHeader("mainThread", ThreadLocalContext.get().getMainThread());
        httpBase.setConfig(RequestConfig.custom().setSocketTimeout(timeout).setConnectTimeout(timeout).setConnectionRequestTimeout(timeout).build());
    }

    private void logParam(String url, String bodyJson, Map<String, String> headers) {
        RequestLog.info((String)("\u5f00\u59cb\u8c03\u7528[" + url + "]"));
        if (bodyJson != null) {
            RequestLog.info((String)("\u8bf7\u6c42\u53c2\u6570\uff1a" + bodyJson));
        }
        RequestLog.info((String)("\u8bf7\u6c42\u5934\u4fe1\u606f\uff1a" + JsonUtils.toJson(headers)));
    }

    private boolean isHttps(String url) {
        return StrUtils.trimStr(url).toLowerCase().startsWith(HTTPS);
    }

    public HttpHost getProxy() {
        return this.proxy;
    }

    public HttpUtilBase setProxy(HttpHost proxy) {
        this.proxy = proxy;
        return this;
    }
}

