/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.logger.LoggerUtils;
import com.uniapis.utils.FileReadUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.WriterFile;
import com.uniapis.utils.Zip;
import java.io.File;
import java.io.InputStream;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Function;

public class FileUtils {
    public static List<String> readJarFile(String path) {
        return FileReadUtils.readJarFile(path);
    }

    public static List<String> readLocalFile(String path) {
        return FileReadUtils.readLocalFile(path);
    }

    public static <T> List<T> readLocalFile(String path, Function<String, T> func) {
        return FileReadUtils.readLocalFile(path, func);
    }

    public static Map<?, ?> loadYml(String fileName) {
        return LoggerUtils.loadYml((String)fileName);
    }

    public static Object readYmlValue(String fileName, String prefix) {
        return LoggerUtils.readYmlValue((String)fileName, (String)prefix);
    }

    public static String zip(String path) {
        File source = new File(path);
        String target = source.getParent() + "/" + source.getName() + "." + System.currentTimeMillis() + ".zip";
        Zip.zip(path, target, new String[0]);
        return target;
    }

    public static String zip(String path, String[] includexts) {
        File source = new File(path);
        String target = source.getParent() + "/" + source.getName() + "." + System.currentTimeMillis() + ".zip";
        Zip.zip(path, target, includexts);
        return target;
    }

    public static String zip(String path, String target) {
        File source = new File(path);
        Zip.zip(path, target, new String[0]);
        return target;
    }

    public static String zip(String path, String target, String[] includexts) {
        File source = new File(path);
        Zip.zip(path, target, includexts);
        return target;
    }

    public static void unzip(InputStream zipInStream, String target) {
        Zip.unzip(zipInStream, target);
    }

    public static void unzip(String source, String target) {
        Zip.unzip(source, target);
    }

    public static void writeFile(String path, Collection<?> list) {
        WriterFile.write(path, list, false);
    }

    public static void writeFile(String path, Collection<?> list, boolean isAppend) {
        WriterFile.write(path, list, isAppend);
    }

    public static void createDirs(String path) {
        WriterFile.createDirs(path);
    }

    public static String replaceSlash(String path) {
        if (StrUtils.isNull(path)) {
            return "";
        }
        return path.replaceAll("(?<!:)//+", "/");
    }

    public static String fileName(String path) {
        return new File(path).getName();
    }
}

