/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.utils.Enums;
import com.uniapis.utils.StrUtils;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class EnumUtils {
    private static Map<String, Map<String, String>> enumMap = new HashMap<String, Map<String, String>>();

    public static void add(String field, Enums[] e) {
        enumMap.put(field, Arrays.stream(e).collect(Collectors.toMap(Enums::code, Enums::cname)));
    }

    public static void add(String field, String[][] args) {
        EnumUtils.add(field, EnumUtils.enumMap(args));
    }

    public static void add(String field, Map<String, String> map) {
        if (enumMap.get(field) == null) {
            enumMap.put(field, map);
        } else {
            enumMap.get(field).putAll(map);
        }
    }

    public static String name(String field, Object value) {
        return EnumUtils.enums(field).getOrDefault(value, StrUtils.trimStr(value));
    }

    public static boolean isNull(String field, Object value) {
        return StrUtils.isNull(EnumUtils.name(field, value));
    }

    public static Map<String, String> enums(String field) {
        return enumMap.getOrDefault(field, new HashMap());
    }

    public static List<Map<String, String>> enumList(String field) {
        return EnumUtils.enums(field).entrySet().stream().map(entry -> {
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("code", entry.getKey());
            result.put("name", entry.getValue());
            return result;
        }).collect(Collectors.toList());
    }

    private static Map<String, String> enumMap(String[][] args) {
        return Stream.of(args).collect(Collectors.toMap(e -> e[0], e -> e[1]));
    }
}

