/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.utils;

import com.uniapis.utils.StrUtils;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

public class DateUtils {
    public static java.sql.Date maxDate() {
        return java.sql.Date.valueOf("9999-09-09");
    }

    public static Timestamp sysTimestamp() {
        return new Timestamp(System.currentTimeMillis());
    }

    public static java.sql.Date sysDate() {
        return new java.sql.Date(System.currentTimeMillis());
    }

    public static Time sysTime() {
        return new Time(System.currentTimeMillis());
    }

    public static String sysDate4Str() {
        return new java.sql.Date(System.currentTimeMillis()).toString();
    }

    public static int dateBetween(Date d1, Date d2, DateType dateType) {
        if (d1.before(d2)) {
            return -1;
        }
        Calendar c1 = Calendar.getInstance();
        c1.setTime(d1);
        Calendar c2 = Calendar.getInstance();
        c2.setTime(d2);
        if (DateType.YEAR.equals((Object)dateType)) {
            return c1.get(1) - c2.get(1);
        }
        if (DateType.MONTH.equals((Object)dateType)) {
            return (c1.get(1) - c2.get(1)) * 12 + c1.get(2) - c2.get(2);
        }
        if (DateType.DAY.equals((Object)dateType)) {
            return (int)((c1.getTimeInMillis() - c2.getTimeInMillis()) / 86400000L);
        }
        if (DateType.HH.equals((Object)dateType)) {
            return (int)((c1.getTimeInMillis() - c2.getTimeInMillis()) / 3600000L);
        }
        if (DateType.MI.equals((Object)dateType)) {
            return (int)((c1.getTimeInMillis() - c2.getTimeInMillis()) / 60000L);
        }
        if (DateType.SS.equals((Object)dateType)) {
            return (int)((c1.getTimeInMillis() - c2.getTimeInMillis()) / 1000L);
        }
        return -2;
    }

    public static Date str2Timestamp(String date) {
        return DateUtils.str2Timestamp(date, "yyyy-MM-dd HH:mm:ss");
    }

    public static Date str2Timestamp(String date, String pattern) {
        SimpleDateFormat clsFormat = new SimpleDateFormat(pattern);
        try {
            clsFormat.parse(date);
            return new Timestamp(clsFormat.parse(date).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date string2Date(Object date) {
        if (StrUtils.isNull(date)) {
            throw new NullPointerException("\u5165\u53c2\u4e3a\u7a7a");
        }
        if (date instanceof Date) {
            return new java.sql.Date(((Date)date).getTime());
        }
        String strDate = StrUtils.trimStr(date);
        int length = strDate.length();
        if (length < 5) {
            throw new RuntimeException("\u975e\u65e5\u671f\u7c7b\u578b");
        }
        if (length >= 10) {
            try {
                return DateUtils.str2Timestamp(strDate);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        String dateSpace = "";
        if (strDate.contains("-") || strDate.contains("/")) {
            dateSpace = String.valueOf(strDate.charAt(4));
        }
        String[] format = !StrUtils.isNull(dateSpace) ? new String[]{"yyyy" + dateSpace + "MM" + dateSpace + "dd", "yyyy" + dateSpace + "MM", "yyyy" + dateSpace + "MM" + dateSpace + "d", "yyyy" + dateSpace + "M" + dateSpace + "dd", "yyyy" + dateSpace + "M" + dateSpace + "d", "yyyy" + dateSpace + "M"} : new String[]{"yyyyMMdd", "yyyyMM", "yyyyMMd", "yyyyMdd", "yyyyMd", "yyyyM"};
        String aFormat = "";
        String tmp = "";
        Date frmDate = null;
        for (int i = 0; i < format.length; ++i) {
            aFormat = format[i];
            SimpleDateFormat formatter = new SimpleDateFormat(aFormat);
            formatter.setLenient(false);
            try {
                frmDate = formatter.parse(strDate);
                tmp = formatter.format(frmDate);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            if (!strDate.equals(tmp)) continue;
            return new java.sql.Date(frmDate.getTime());
        }
        throw new RuntimeException("\u975e\u65e5\u671f\u7c7b\u578b");
    }

    public static Time string2Time(String time) {
        SimpleDateFormat clsFormat = new SimpleDateFormat("HH:mm:ss");
        try {
            return new Time(clsFormat.parse(time).getTime());
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static Date object2Date(Object date) {
        return DateUtils.string2Date(StrUtils.trimStr(date));
    }

    public static Date string2Date(String date, String frm) {
        SimpleDateFormat clsFormat = new SimpleDateFormat(frm);
        try {
            clsFormat.parse(date);
            return clsFormat.parse(date);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    public static String date2String(Date date) {
        SimpleDateFormat clsFormat = new SimpleDateFormat("yyyy-MM-dd");
        return clsFormat.format(date);
    }

    public static String date2String(Date date, String frm) {
        SimpleDateFormat clsFormat = new SimpleDateFormat(frm);
        return clsFormat.format(date);
    }

    public static Date addDate(Date date, DateType dateType, int num) {
        Calendar c1 = Calendar.getInstance();
        c1.setTime(date);
        if (DateType.YEAR.equals((Object)dateType)) {
            c1.add(1, num);
            return c1.getTime();
        }
        if (DateType.MONTH.equals((Object)dateType)) {
            c1.add(2, num);
            return c1.getTime();
        }
        if (DateType.DAY.equals((Object)dateType)) {
            c1.add(5, num);
            return c1.getTime();
        }
        if (DateType.HH.equals((Object)dateType)) {
            c1.add(11, num);
            return c1.getTime();
        }
        if (DateType.MI.equals((Object)dateType)) {
            c1.add(12, num);
            return c1.getTime();
        }
        if (DateType.SS.equals((Object)dateType)) {
            c1.add(13, num);
            return c1.getTime();
        }
        return date;
    }

    public static java.sql.Date yesterday(Date date) {
        Calendar cdate = Calendar.getInstance();
        cdate.setTime(date);
        cdate.add(5, -1);
        java.sql.Date ldate = new java.sql.Date(cdate.getTime().getTime());
        return ldate;
    }

    public static java.sql.Date firstDayOfLastMonth() {
        return DateUtils.firstDayOfLastMonth(DateUtils.sysDate());
    }

    public static java.sql.Date firstDayOfLastMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, -1);
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static java.sql.Date firstDayOfMonth() {
        Calendar date = Calendar.getInstance();
        date.set(5, 1);
        java.sql.Date sysDate = new java.sql.Date(date.getTime().getTime());
        return sysDate;
    }

    public static java.sql.Date firstDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(5, 1);
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static String firstDayOfNextMonth(String calcdate) {
        return DateUtils.date2String(DateUtils.firstDayOfNextMonth(DateUtils.string2Date(calcdate)));
    }

    public static java.sql.Date firstDayOfNextMonth(Date calcdate) {
        Calendar date = Calendar.getInstance();
        date.setTime(calcdate);
        date.add(2, 1);
        date.set(5, date.getMinimum(5));
        java.sql.Date sysDate = new java.sql.Date(date.getTime().getTime());
        return sysDate;
    }

    public static int compareDate(Date startDate, Date endDate) {
        if ((startDate = DateUtils.string2Date(startDate.toString())).before(endDate = DateUtils.string2Date(endDate.toString()))) {
            return -1;
        }
        if (startDate.equals(endDate)) {
            return 0;
        }
        if (startDate.after(endDate)) {
            return 1;
        }
        return -2;
    }

    public static Date lastDayOfLastMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, -1);
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, 0);
        cal.set(12, 0);
        cal.set(13, 0);
        cal.set(14, 0);
        return cal.getTime();
    }

    public static java.sql.Date lastDayOfMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(5, cal.getActualMaximum(5));
        cal.set(11, cal.getActualMaximum(11));
        cal.set(12, cal.getActualMaximum(12));
        cal.set(13, cal.getActualMaximum(13));
        cal.set(14, cal.getActualMaximum(14));
        return new java.sql.Date(cal.getTimeInMillis());
    }

    public static Date lastDayOfNextMonth(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.add(2, 1);
        return DateUtils.lastDayOfMonth(cal.getTime());
    }

    public static int getDayOfDate(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        return cal.get(5);
    }

    public static java.sql.Date obj2SqlDate(Object obj) {
        if (obj instanceof Date) {
            return new java.sql.Date(((Date)obj).getTime());
        }
        throw new RuntimeException("\u5165\u53c2\u4e0d\u4e3a\u65e5\u671f\u7c7b\u578b");
    }

    public static Timestamp obj2Timestamp(Object obj) {
        if (obj instanceof Date) {
            return new Timestamp(((Date)obj).getTime());
        }
        throw new RuntimeException("\u5165\u53c2\u4e0d\u4e3a\u65e5\u671f\u7c7b\u578b");
    }

    public static double calcAge(Date birthday) {
        return DateUtils.calcAge(birthday, new java.sql.Date(System.currentTimeMillis()));
    }

    public static double calcAge(Date birthday, Date date) {
        Calendar aBirthday = Calendar.getInstance();
        aBirthday.setTime(birthday);
        Calendar sysDate = Calendar.getInstance();
        sysDate.setTimeInMillis(date.getTime());
        return (double)(sysDate.get(1) - aBirthday.get(1)) + (double)(sysDate.get(2) - aBirthday.get(2)) / 12.0 + (double)(sysDate.get(5) - aBirthday.get(5)) / 365.0;
    }

    public static Date getBefore1Hour(Date date) {
        Calendar cal = Calendar.getInstance();
        if (date != null) {
            cal.setTime(date);
        }
        cal.set(10, 9);
        return cal.getTime();
    }

    public static boolean isValidDate(String date) {
        try {
            DateUtils.str2Timestamp(date);
        }
        catch (RuntimeException e1) {
            try {
                DateUtils.string2Date(date);
            }
            catch (RuntimeException e2) {
                return false;
            }
            return true;
        }
        return true;
    }

    public static String time2Str(Time time) {
        if (time == null) {
            return "";
        }
        return DateUtils.date2String(time, "HH:mm:ss");
    }

    public static Date trunc(Date date) {
        return DateUtils.trunc(date, DateType.DAY);
    }

    public static Date trunc(Date date, DateType dateType) {
        if (date == null) {
            return date;
        }
        Calendar c = Calendar.getInstance();
        c.setTime(date);
        switch (dateType) {
            case YEAR: {
                c.set(2, 0);
                break;
            }
            case MONTH: {
                c.set(5, 1);
                break;
            }
            case DAY: {
                c.set(10, 0);
                break;
            }
            case HH: {
                c.set(12, 0);
                break;
            }
            case MI: {
                c.set(13, 0);
                break;
            }
            case SS: {
                c.set(14, 0);
                break;
            }
        }
        return c.getTime();
    }

    public static void main(String[] args) {
        DateUtils.isValidDate("2010-10");
    }

    public static enum DateType {
        YEAR,
        MONTH,
        DAY,
        HH,
        MI,
        SS,
        YYYY_MM_DD,
        YYYYMMDD;

    }
}

