/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.sharding.pojo;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.sharding.ShardCodeCallback;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.StrUtils;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public final class ShardCode {
    private String codeKey;
    private Scope codeScope;
    private String value;
    private ShardCodeCallback callback;

    public ShardCode() {
    }

    public ShardCode(Scope codeScope) {
        this(null, codeScope, null, null);
    }

    public ShardCode(String codeKey, Scope codeScope) {
        this(codeKey, codeScope, null, null);
    }

    public ShardCode(String codeKey, Scope codeScope, String value) {
        this(codeKey, codeScope, value, null);
    }

    public ShardCode(String codeKey, Scope codeScope, ShardCodeCallback callback) {
        this(codeKey, codeScope, null, callback);
    }

    public ShardCode(String codeKey, Scope codeScope, String value, ShardCodeCallback callback) {
        this.codeKey = codeKey;
        this.codeScope = codeScope;
        this.value = value;
        this.callback = callback;
    }

    public String getCodeKey() {
        return this.codeKey;
    }

    public void setCodeKey(String codeKey) {
        this.codeKey = codeKey;
    }

    public Scope getCodeScope() {
        return this.codeScope;
    }

    public void setCodeScope(Scope codeScope) {
        this.codeScope = codeScope;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getValue(ServletRequest request) {
        String value = this.getCodeScopeValue(request);
        if (this.callback != null) {
            value = this.callback.callback(value);
        }
        return value;
    }

    private String getCodeScopeValue(ServletRequest request) {
        boolean needRequest;
        boolean bl = needRequest = Scope.Request.equals((Object)this.getCodeScope()) || Scope.Url.equals((Object)this.getCodeScope());
        if (needRequest && request == null) {
            throw new RuntimeException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a");
        }
        switch (this.getCodeScope()) {
            case Request: {
                return StrUtils.trimStr((Object)request.getParameter(this.getCodeKey()));
            }
            case Url: {
                return StrUtils.trimStr((Object)this.getServletPath(request));
            }
            case UserProperty: {
                if (ThreadLocalContext.get() == null || ThreadLocalContext.get().getUser() == null) {
                    return "";
                }
                return StrUtils.trimStr((Object)ClassUtils.getProperty((Object)ThreadLocalContext.get().getUser(), (String)this.getCodeKey()));
            }
            case Value: {
                return this.value;
            }
        }
        return "";
    }

    private String getServletPath(ServletRequest request) {
        String url = StrUtils.trimStr((Object)((HttpServletRequest)request).getServletPath());
        if (url.startsWith("/")) {
            url = url.substring(1, url.length());
        }
        return url;
    }

    public static enum Scope {
        Request,
        UserProperty,
        Url,
        Value,
        None;

    }
}

