/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.sharding;

import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.sharding.model.DbDatabase;
import com.uniapis.repository.sharding.model.DbSharding;
import com.uniapis.utils.StrUtils;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class RoutingDatabase {
    @Autowired(required=false)
    private AbsModelRepository dao;

    public Map<String, DbDatabase> initShardingMap() {
        HashMap<String, DbDatabase> shardingMap = new HashMap<String, DbDatabase>();
        DbSharding shard = new DbSharding();
        shard.setOrderBy(DbSharding.CRT_DATE.asc());
        shard.where().setCheckWhere(false);
        DbDatabase db = new DbDatabase();
        List<DbSharding> shardList = this.dao.findAll(shard);
        for (DbSharding aShard : shardList) {
            String shardCode = "";
            if (!StrUtils.isNull((Object)aShard.getUpShard())) {
                shardCode = this.findUpShard(aShard.getUpShard()) + aShard.getShardCode();
            }
            db.where().addEq(DbDatabase.DATABASE_NO, aShard.getDatabaseNo());
            shardingMap.put(shardCode, this.dao.findOne(db));
        }
        return shardingMap;
    }

    private String findUpShard(String upShard) {
        if (StrUtils.isNull((Object)upShard)) {
            return "";
        }
        DbSharding shard = new DbSharding();
        shard.where().addEq(DbSharding.SHARD_NO, upShard);
        shard = this.dao.findOne(shard);
        String shardCode = "";
        if (!StrUtils.isNull((Object)shard.getUpShard())) {
            shardCode = this.findUpShard(shard.getUpShard());
        }
        return shardCode + StrUtils.trimStr((Object)shard.getShardCode()) + ".";
    }
}

