/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.datasource;

import com.alibaba.druid.pool.DruidDataSource;
import com.uniapis.logger.Ulog;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.repository.datasource.RoutingDataSource;
import com.uniapis.repository.sharding.model.DbDatabase;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.BeansException;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.ApplicationListener;
import org.springframework.context.event.ContextRefreshedEvent;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.datasource.url"})
public class MultipleDataSource
implements BeanFactoryPostProcessor,
ApplicationListener<ContextRefreshedEvent> {
    private DefaultListableBeanFactory beanFactory;

    private void callback(AbsModelRepository dao) {
        DruidDataSource dataSource = SpringContext.getBean("dataSource", DruidDataSource.class);
        DbDatabase dbDao = new DbDatabase();
        dbDao.where().setCheckWhere(false).model();
        List<DbDatabase> dbList = dao.findAll(dbDao, false);
        HashMap<Object, Object> targetDataSources = new HashMap<Object, Object>();
        for (DbDatabase database : dbList) {
            DruidDataSource newDs = this.initDataSource(database.getUrl(), database.getDbUser(), database.getDbPwd(), database.getDatabaseNo(), dataSource);
            targetDataSources.put(database.getDatabaseNo(), newDs);
        }
        RoutingDataSource routingDataSource = SpringContext.getBean("routingDataSource", RoutingDataSource.class);
        routingDataSource.setTargetDataSources(targetDataSources);
    }

    public DruidDataSource initDataSource(String url, String dbUser, String dbPwd, String dbNo, DruidDataSource dataSource) {
        DruidDataSource newDs = new DruidDataSource();
        newDs.setUrl(url);
        newDs.setUsername(dbUser);
        newDs.setPassword(dbPwd);
        this.cloneDataSource(dataSource, newDs);
        Ulog.debug((String)("\u521d\u59cb\u5316\u6570\u636e\u6e90\u5bf9\u8c61\u3010" + dbNo + "\u3011"));
        this.registerSingletonBean(dbNo, newDs);
        return newDs;
    }

    private void registerSingletonBean(String key, Object bean) {
        if (!this.beanFactory.containsBean(key)) {
            this.beanFactory.registerSingleton(key, bean);
        }
    }

    private void cloneDataSource(DruidDataSource oldDs, DruidDataSource newDs) {
        newDs.setInitialSize(oldDs.getInitialSize());
        newDs.setMinIdle(oldDs.getMinIdle());
        newDs.setMaxActive(oldDs.getMaxActive());
        newDs.setMaxWait(oldDs.getMaxWait());
        newDs.setTimeBetweenEvictionRunsMillis(oldDs.getTimeBetweenEvictionRunsMillis());
        newDs.setMinEvictableIdleTimeMillis(oldDs.getMinEvictableIdleTimeMillis());
        newDs.setValidationQuery(oldDs.getValidationQuery());
        newDs.setTestWhileIdle(oldDs.isTestWhileIdle());
        newDs.setTestOnBorrow(oldDs.isTestOnBorrow());
        newDs.setTestOnReturn(oldDs.isTestOnReturn());
        newDs.setPoolPreparedStatements(oldDs.isPoolPreparedStatements());
        newDs.setMaxPoolPreparedStatementPerConnectionSize(oldDs.getMaxPoolPreparedStatementPerConnectionSize());
        newDs.setProxyFilters(oldDs.getProxyFilters());
    }

    public void postProcessBeanFactory(ConfigurableListableBeanFactory beanFactory) throws BeansException {
        this.beanFactory = (DefaultListableBeanFactory)beanFactory;
    }

    public void onApplicationEvent(ContextRefreshedEvent context) {
        this.callback((AbsModelRepository)context.getApplicationContext().getBean(AbsModelRepository.class));
    }
}

