/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.config;

import com.uniapis.logger.LoggerUtils;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.repository.core.utils.DatabasePasswordDecode;
import com.uniapis.utils.StrUtils;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.stereotype.Component;

@Component
@ConfigurationProperties(prefix="spring.datasource")
@ConditionalOnProperty(name={"spring.datasource.url"})
public class DataSourceProperties {
    private String url;
    private String username;
    private String password;
    private String dialect;
    private String paging;
    private String procedureQuery;
    private String driverClassName;
    private Map<String, DataSourceProperties> otherDatasource;
    private Map<String, String> druid;
    @Autowired(required=false)
    private DatabasePasswordDecode passwordDecode;
    private static DBTypes dbType;
    private static boolean isPaging;
    private static boolean isProcedureQuery;

    public String getUrl() {
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        if (this.passwordDecode != null) {
            return this.passwordDecode.decodePassword(this.password);
        }
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getDialect() {
        return this.dialect;
    }

    public void setDialect(String dialect) {
        this.dialect = dialect;
        if (StrUtils.isNull((Object)((Object)dbType))) {
            dbType = DBTypes.valueOf(this.dialect);
        }
    }

    public Map<String, DataSourceProperties> getOtherDatasource() {
        return this.otherDatasource;
    }

    public void setOtherDatasource(Map<String, DataSourceProperties> otherDatasource) {
        this.otherDatasource = otherDatasource;
    }

    public Map<String, String> getDruid() {
        return this.druid;
    }

    public void setDruid(Map<String, String> druid) {
        this.druid = druid;
    }

    public void setProcedureQuery(String procedureQuery) {
        this.procedureQuery = procedureQuery;
    }

    public String getPaging() {
        return this.paging;
    }

    public void setPaging(String paging) {
        this.paging = paging;
    }

    public static boolean isProcedureQuery() {
        return isProcedureQuery;
    }

    public static DBTypes dbTypes() {
        return dbType;
    }

    public static boolean isPaging() {
        return isPaging;
    }

    public String getDriverClassName() {
        return this.driverClassName;
    }

    public void setDriverClassName(String driverClassName) {
        this.driverClassName = driverClassName;
    }

    static {
        isPaging = false;
        isProcedureQuery = true;
        Object obj = LoggerUtils.readYmlValue((String)"/config/application.yml", (String)"spring.datasource");
        HashMap<String, String> dataSource = new HashMap<String, String>();
        dataSource.put("dialect", "MYSQL");
        dataSource.put("procedureQuery", "NONE");
        if (!StrUtils.isNull((Object)obj) && !((Map)obj).isEmpty()) {
            dataSource.putAll((Map)obj);
        }
        dbType = DBTypes.valueOf(StrUtils.trimStr(dataSource.get("dialect")));
        isPaging = "PAGING".equalsIgnoreCase(StrUtils.trimStr(dataSource.get("paging")));
        isProcedureQuery = "".equalsIgnoreCase(StrUtils.trimStr(dataSource.get("procedureQuery"))) || "PROCEDURE".equalsIgnoreCase(StrUtils.trimStr(dataSource.get("procedureQuery")));
    }
}

