/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.test;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.context.pojo.User;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.Return;
import com.uniapis.msg.pojo.Message;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.test.db.IDbUnitHelper;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.io.File;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.extension.ExtendWith;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.springframework.test.context.junit.jupiter.SpringExtension;
import org.springframework.transaction.annotation.Transactional;

@ExtendWith(value={SpringExtension.class})
@SpringBootTest
@Transactional
public class TestHelper {
    private static IDbUnitHelper dbHelper;
    private static File tempFile;
    @Autowired
    private AbsModelRepository dao;

    @BeforeAll
    public static final void initUserInfo() {
        User user = new User();
        user.setUserCode("test_helper");
        user.setPkUuid("helper_uuid");
        user.setBranchType("00");
        ThreadLocalContext.get().setUser(user);
    }

    public final IDbUnitHelper getDbHelper() {
        if (dbHelper == null) {
            dbHelper = SpringContext.getBean(IDbUnitHelper.class);
        }
        return dbHelper;
    }

    public final void backup(String ... tableName) {
        try {
            if (tempFile == null) {
                tempFile = this.getDbHelper().backup(tableName);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void backup2xml(String fileName, String ... sqls) {
        try {
            this.getDbHelper().backup(this.getClass(), fileName, sqls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final IDataSet getDataSet(String fileName) {
        try {
            return this.getDbHelper().getDataSet(this.getClass(), fileName);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void initDb(String xmlName) {
        try {
            if (!xmlName.endsWith("xml")) {
                this.xls2xml(xmlName);
                xmlName = xmlName.split("\\.")[0] + ".xml";
            }
            this.getDbHelper().initDb(this.getClass(), xmlName);
        }
        catch (Exception e) {
            Ulog.info((String)("xmlName==" + xmlName));
            throw new RuntimeException(e);
        }
    }

    public final IDataSet queryData(String ... sqls) {
        try {
            return this.getDbHelper().queryData(sqls);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public static final void rollback() {
        try {
            dbHelper.rollback(tempFile);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            tempFile = null;
        }
    }

    public final void xls2xml(String fileName) {
        try {
            this.getDbHelper().xls2xml(this.getClass(), fileName, true);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void xls2xml(String fileName, boolean initBaseClm) {
        try {
            this.getDbHelper().xls2xml(this.getClass(), fileName, initBaseClm);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public final void dataSetEquals(IDataSet expectedDataSet, IDataSet actualDataSet, String ... excludedCol) {
        this.getDbHelper().dataSetEquals(expectedDataSet, actualDataSet, excludedCol);
    }

    public final void tableEquals(ITable expectedDataSet, ITable actualDataSet, String ... excludedCol) {
        this.getDbHelper().tableEquals(expectedDataSet, actualDataSet, excludedCol);
    }

    public final Return wrapperReturn(String json) {
        return this.wrapperReturn(json, null);
    }

    public final Return wrapperReturn(String json, Class<?> requiredType) {
        if (StrUtils.isNull((Object)json)) {
            return new Return();
        }
        Map map = JsonUtils.json2Map((String)json);
        Return returnMsg = new Return();
        this.initMessage(map, returnMsg);
        this.initData(map, returnMsg, requiredType);
        this.initDefMap(map, returnMsg);
        return returnMsg;
    }

    public final Return wrapperReturn(HttpServletResponse response) {
        String json = "";
        try {
            json = ((MockHttpServletResponse)response).getContentAsString();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        return this.wrapperReturn(json);
    }

    private void initMessage(Map<String, Object> map, Return returnMsg) {
        List msg = (List)map.get("msg");
        ArrayList<Message> msgList = new ArrayList<Message>();
        for (Map aMsg : msg) {
            for (Map.Entry entry : aMsg.entrySet()) {
                msgList.add(new Message((String)entry.getKey(), StrUtils.trimStr(entry.getValue())));
            }
        }
        if ("success".equals(map.get("flag"))) {
            returnMsg.setSuccessMsg(msgList);
        }
        if ("warn".equals(map.get("flag"))) {
            returnMsg.setWarnMsg(msgList);
        }
        if ("fail".equals(map.get("flag"))) {
            returnMsg.setFailMsg(msgList);
        }
    }

    private <T> void initData(Map<String, Object> map, Return returnMsg, Class<T> requiredType) {
        List dataList = (List)map.get("data");
        returnMsg.setDataList(dataList);
        if (requiredType == null) {
            return;
        }
        returnMsg.setDataList(JsonUtils.listMap2ListClass((List)dataList, requiredType), requiredType);
    }

    private void initDefMap(Map<String, Object> map, Return returnMsg) {
        Map dataTable = (Map)map.get("defmap");
        returnMsg.setDataTable(dataTable);
    }
}

