/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.sharding.model;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;
import org.springframework.data.domain.Sort;

@Table(name="db_sharding")
public class DbSharding
extends AbsModel {
    @Column(name="shard_no")
    @JsonProperty(value="shard_no")
    private String shardNo;
    @Column(name="shard_type")
    @JsonProperty(value="shard_type")
    private String shardType;
    @Column(name="shard_code")
    @JsonProperty(value="shard_code")
    private String shardCode;
    @Column(name="up_shard")
    @JsonProperty(value="up_shard")
    private String upShard;
    @Column(name="database_no")
    @JsonProperty(value="database_no")
    private String databaseNo;
    @Column(name="data_flag")
    @JsonProperty(value="data_flag")
    private String dataFlag = "1";
    @Column(name="patch_memo")
    @JsonProperty(value="patch_memo")
    private String patchMemo;
    @Transient
    @JsonIgnore
    private Where<DbSharding> where = Where.getInstance(this);
    @Transient
    @JsonIgnore
    private GroupBy<DbSharding> groupby = GroupBy.getInstance(this);
    @Transient
    public static final Field SHARD_NO = new Field("shardNo", "shard_no");
    @Transient
    public static final Field SHARD_TYPE = new Field("shardType", "shard_type");
    @Transient
    public static final Field SHARD_CODE = new Field("shardCode", "shard_code");
    @Transient
    public static final Field UP_SHARD = new Field("upShard", "up_shard");
    @Transient
    public static final Field DATABASE_NO = new Field("databaseNo", "database_no");
    @Transient
    public static final Field DATA_FLAG = new Field("dataFlag", "data_flag");
    @Transient
    public static final Field PATCH_MEMO = new Field("patchMemo", "patch_memo");

    public DbSharding() {
    }

    public DbSharding(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        String patchMemo;
        String dataFlag;
        String databaseNo;
        String upShard;
        String shardCode;
        String shardType;
        Return ret = new Return();
        String shardNo = StrUtils.trimStr((Object)this.shardNo);
        if (shardNo.length() > 32) {
            ret.setFailMsg("[\u5206\u7247\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + shardNo.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.shardNo)) {
            ret.setFailMsg("[\u5206\u7247\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((shardType = StrUtils.trimStr((Object)this.shardType)).length() > 32) {
            ret.setFailMsg("[\u5206\u7247\u7c7b\u578b]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + shardType.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.shardType)) {
            ret.setFailMsg("[\u5206\u7247\u7c7b\u578b]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((shardCode = StrUtils.trimStr((Object)this.shardCode)).length() > 64) {
            ret.setFailMsg("[\u5206\u7247\u7279\u5f81\u4ee3\u7801]\u4e0d\u80fd\u8d85\u8fc7[64]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + shardCode.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.shardCode)) {
            ret.setFailMsg("[\u5206\u7247\u7279\u5f81\u4ee3\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((upShard = StrUtils.trimStr((Object)this.upShard)).length() > 32) {
            ret.setFailMsg("[\u4e0a\u7ea7\u5206\u7247\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + upShard.length() + "]\u4f4d");
        }
        if ((databaseNo = StrUtils.trimStr((Object)this.databaseNo)).length() > 32) {
            ret.setFailMsg("[\u6570\u636e\u5e93\u7f16\u7801]\u4e0d\u80fd\u8d85\u8fc7[32]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + databaseNo.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.databaseNo)) {
            ret.setFailMsg("[\u6570\u636e\u5e93\u7f16\u7801]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((dataFlag = StrUtils.trimStr((Object)this.dataFlag)).length() > 4) {
            ret.setFailMsg("[09.\u6709\u6548\u6027\u6807\u5fd7]\u4e0d\u80fd\u8d85\u8fc7[4]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + dataFlag.length() + "]\u4f4d");
        }
        if (StrUtils.isNull((Object)this.dataFlag)) {
            ret.setFailMsg("[09.\u6709\u6548\u6027\u6807\u5fd7]\u4e0d\u80fd\u4e3a\u7a7a");
        }
        if ((patchMemo = StrUtils.trimStr((Object)this.patchMemo)).length() > 1024) {
            ret.setFailMsg("[10.\u6570\u8865\u5907\u6ce8]\u4e0d\u80fd\u8d85\u8fc7[1024]\u4f4d\uff0c\u5b9e\u9645\u4e3a[" + patchMemo.length() + "]\u4f4d");
        }
        return ret;
    }

    public DbSharding setShardNo(String shardNo) {
        this.shardNo = shardNo;
        this.where().setChangeColumn(SHARD_NO);
        return this;
    }

    public String getShardNo() {
        return this.shardNo;
    }

    public DbSharding setShardType(String shardType) {
        this.shardType = shardType;
        this.where().setChangeColumn(SHARD_TYPE);
        return this;
    }

    public String getShardType() {
        return this.shardType;
    }

    public DbSharding setShardCode(String shardCode) {
        this.shardCode = shardCode;
        this.where().setChangeColumn(SHARD_CODE);
        return this;
    }

    public String getShardCode() {
        return this.shardCode;
    }

    public DbSharding setUpShard(String upShard) {
        this.upShard = upShard;
        this.where().setChangeColumn(UP_SHARD);
        return this;
    }

    public String getUpShard() {
        return this.upShard;
    }

    public DbSharding setDatabaseNo(String databaseNo) {
        this.databaseNo = databaseNo;
        this.where().setChangeColumn(DATABASE_NO);
        return this;
    }

    public String getDatabaseNo() {
        return this.databaseNo;
    }

    public DbSharding setDataFlag(String dataFlag) {
        this.dataFlag = dataFlag;
        this.where().setChangeColumn(DATA_FLAG);
        return this;
    }

    public String getDataFlag() {
        return this.dataFlag;
    }

    public DbSharding setPatchMemo(String patchMemo) {
        this.patchMemo = patchMemo;
        this.where().setChangeColumn(PATCH_MEMO);
        return this;
    }

    public String getPatchMemo() {
        return this.patchMemo;
    }

    @Override
    @JsonIgnore
    public DbSharding select(Field ... fields) {
        super.select(fields);
        return this;
    }

    @JsonIgnore
    public Where<DbSharding> where() {
        return this.where;
    }

    @JsonIgnore
    public GroupBy<DbSharding> groupBy() {
        return this.groupby;
    }

    @Override
    @JsonIgnore
    public DbSharding setOrderBy(Sort.Order ... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static DbSharding n() {
        return new DbSharding();
    }

    @JsonIgnore
    public static DbSharding n(boolean appendWhere) {
        return new DbSharding(appendWhere);
    }
}

