/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.sharding.impl;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.repository.sharding.RoutingDatabase;
import com.uniapis.repository.sharding.Shardingable;
import com.uniapis.repository.sharding.model.DbDatabase;
import com.uniapis.repository.sharding.pojo.ShardCode;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.ThreadContext;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component
@ConditionalOnProperty(name={"spring.datasource.sharding"}, havingValue="ORGAN")
public class OrganSharding
implements Shardingable {
    @Autowired
    private RoutingDatabase routingDB;
    private static final Map<String, DbDatabase> DATA_SOURCE_MAP = new HashMap<String, DbDatabase>();
    private boolean isInitDataSource = false;

    @Override
    public void defaultDataBase() {
        ThreadLocalContext.get().setDataSource("dataSource");
        ThreadLocalContext.get().setDataSourceName("\u9ed8\u8ba4\u5e93");
    }

    @Override
    public void initSharding(String ... shardCode) {
        String organId = "";
        String url = "";
        if (shardCode.length >= 2) {
            organId = StrUtils.trimStr((Object)shardCode[0]);
            url = StrUtils.trimStr((Object)shardCode[1]);
        }
        if (!this.isInitDataSource) {
            DATA_SOURCE_MAP.putAll(this.routingDB.initShardingMap());
            this.isInitDataSource = true;
        }
        if (!StrUtils.isNull((Object)organId) && organId.length() >= 3) {
            organId = organId.substring(0, 3);
        }
        ThreadContext.put((String)"organId", (String)organId);
        DbDatabase aDataSource = null;
        if (!StrUtils.isNull((Object)url)) {
            aDataSource = DATA_SOURCE_MAP.get(organId + "." + url);
        }
        if (aDataSource == null) {
            aDataSource = DATA_SOURCE_MAP.get(organId);
        }
        if (aDataSource != null) {
            ThreadLocalContext.get().setDataSource(aDataSource.getDatabaseNo());
            ThreadLocalContext.get().setDataSourceName(aDataSource.getDatabaseName());
        }
    }

    @Override
    public List<ShardCode> getSharCodeScope() {
        ArrayList<ShardCode> shardCodeList = new ArrayList<ShardCode>();
        shardCodeList.add(this.defaultShardDbCode());
        shardCodeList.add(new ShardCode(ShardCode.Scope.Url));
        return shardCodeList;
    }

    @Override
    public ShardCode defaultShardDbCode() {
        return new ShardCode("organId", ShardCode.Scope.UserProperty, arg -> {
            if (!StrUtils.isNull((Object)arg) && arg.length() >= 3) {
                arg = arg.substring(0, 3);
            }
            return arg;
        });
    }

    @Override
    public ShardCode defaultShardLogCode() {
        return this.defaultShardDbCode();
    }
}

