/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.core;

import com.uniapis.utils.StrUtils;
import java.io.Serializable;
import java.util.Objects;
import org.springframework.data.domain.Sort;

public final class Field
implements Serializable,
Comparable<Field> {
    private String cname = "";
    private String property = "";
    private String column = "";
    private Object value = null;

    public Field(String property, String column) {
        this.property = property;
        this.column = column;
    }

    public Field(String property, String column, String cname) {
        this.property = property;
        this.column = column;
        this.cname = cname;
    }

    public String toString() {
        return this.property;
    }

    public Sort.Order asc() {
        return new Sort.Order(Sort.Direction.ASC, this.column());
    }

    public Sort.Order desc() {
        return new Sort.Order(Sort.Direction.DESC, this.column());
    }

    public String property() {
        return this.property;
    }

    public String column() {
        return this.column;
    }

    public Object getValue() {
        return this.value;
    }

    public void setValue(Object value) {
        this.value = value;
    }

    @Override
    public int compareTo(Field o) {
        return this.column.compareTo(o.column());
    }

    public int hashCode() {
        return StrUtils.trimStr((Object)this.column).hashCode() + StrUtils.trimStr((Object)this.property).hashCode() + StrUtils.trimStr((Object)this.value).hashCode() + StrUtils.trimStr((Object)this.cname).hashCode();
    }

    public boolean equals(Object field) {
        if (field == null || !(field instanceof Field)) {
            return false;
        }
        Field aField = (Field)field;
        return Objects.equals(this.column, aField.column()) && Objects.equals(this.property, aField.property()) && Objects.equals(this.value, aField.getValue());
    }
}

