/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.config;

import com.uniapis.license.RunWithLoader;
import com.uniapis.repository.core.AbsModelRepository;
import java.util.Properties;
import javax.sql.DataSource;
import org.aopalliance.aop.Advice;
import org.springframework.aop.Pointcut;
import org.springframework.aop.aspectj.AspectJExpressionPointcut;
import org.springframework.aop.support.DefaultPointcutAdvisor;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.Configuration;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;
import org.springframework.transaction.PlatformTransactionManager;
import org.springframework.transaction.TransactionManager;
import org.springframework.transaction.interceptor.TransactionInterceptor;

@Configuration
@ComponentScan(basePackages={"com.uniapis.repository"})
public class TransactionConfig {
    @Value(value="${spring.transaction.expression:}")
    private String txExpression;

    @Bean(value={"txManager"})
    @ConditionalOnProperty(name={"spring.datasource.url"})
    public DataSourceTransactionManager txManager(@Qualifier(value="routingDataSource") DataSource dataSource) {
        return new DataSourceTransactionManager(dataSource);
    }

    @Bean
    @ConditionalOnProperty(name={"spring.datasource.url"})
    public DefaultPointcutAdvisor defaultPointcutAdvisor(@Autowired PlatformTransactionManager txManager) {
        DefaultPointcutAdvisor advisor = new DefaultPointcutAdvisor();
        advisor.setPointcut((Pointcut)this.txPointcut());
        advisor.setAdvice((Advice)this.txAdvice(txManager));
        return advisor;
    }

    @Bean
    @ConditionalOnProperty(name={"spring.datasource.url"})
    public AbsModelRepository initAbsModelRepository(@Qualifier(value="defaultJdbcTemplate") JdbcTemplate jdbc) {
        AbsModelRepository repository = (AbsModelRepository)RunWithLoader.getInstance().newInstance("com.uniapis.repository.core.AbsModelRepositoryImpl", AbsModelRepository.class, new Object[0]);
        repository.setJdbcTemplate(jdbc);
        return repository;
    }

    private TransactionInterceptor txAdvice(PlatformTransactionManager txManager) {
        TransactionInterceptor txInterceptor = new TransactionInterceptor();
        txInterceptor.setTransactionManager((TransactionManager)txManager);
        Properties txAttr = new Properties();
        txAttr.setProperty("*", "PROPAGATION_REQUIRED,-Throwable");
        txInterceptor.setTransactionAttributes(txAttr);
        return txInterceptor;
    }

    private AspectJExpressionPointcut txPointcut() {
        AspectJExpressionPointcut pointcut = new AspectJExpressionPointcut();
        pointcut.setExpression(this.txExpression);
        return pointcut;
    }

    @Bean(value={"defaultJdbcTemplate"})
    @ConditionalOnProperty(name={"spring.datasource.url"})
    public JdbcTemplate jdbcTemplate(@Qualifier(value="routingDataSource") DataSource routingDataSource) {
        JdbcTemplate jdbcTemplate = new JdbcTemplate();
        jdbcTemplate.setDataSource(routingDataSource);
        return jdbcTemplate;
    }
}

