/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.config;

import com.alibaba.druid.pool.DruidDataSource;
import com.uniapis.logger.Ulog;
import com.uniapis.repository.config.DataSourceProperties;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import java.sql.SQLException;
import javax.annotation.PostConstruct;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.beans.factory.config.ConfigurableBeanFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.stereotype.Component;

@Component(value="druidDataSourceConfig")
@ConditionalOnProperty(name={"spring.datasource.url"})
public class DruidDataSourceConfig {
    @Autowired
    private ConfigurableBeanFactory beanFactory;
    @Autowired
    private DataSourceProperties dbProps;
    @Value(value="${spring.profiles.active:dev}")
    private String active;

    private void createDataSource(String beanName, DataSourceProperties db) {
        DruidDataSource dataSource = new DruidDataSource();
        dataSource.setUrl(db.getUrl());
        dataSource.setUsername(db.getUsername());
        dataSource.setPassword(db.getPassword());
        if (!StrUtils.isNull((Object)db.getDriverClassName())) {
            dataSource.setDriverClassName(db.getDriverClassName());
        }
        dataSource.setInitialSize(Integer.parseInt(this.config(db, "initialSize")));
        dataSource.setMinIdle(Integer.parseInt(this.config(db, "minIdle")));
        dataSource.setMaxActive(Integer.parseInt(this.config(db, "maxActive")));
        dataSource.setMaxWait((long)Integer.parseInt(this.config(db, "maxWait")));
        dataSource.setTimeBetweenEvictionRunsMillis((long)Integer.parseInt(this.config(db, "timeBetweenEvictionRunsMillis")));
        dataSource.setMinEvictableIdleTimeMillis((long)Integer.parseInt(this.config(db, "minEvictableIdleTimeMillis")));
        dataSource.setValidationQuery(this.config(db, "validationQuery"));
        dataSource.setTestWhileIdle(Boolean.parseBoolean(this.config(db, "testWhileIdle")));
        dataSource.setTestOnBorrow(Boolean.parseBoolean(this.config(db, "testOnBorrow")));
        dataSource.setTestOnReturn(Boolean.parseBoolean(this.config(db, "testOnReturn")));
        dataSource.setPoolPreparedStatements(Boolean.parseBoolean(this.config(db, "poolPreparedStatements")));
        dataSource.setMaxPoolPreparedStatementPerConnectionSize(Integer.parseInt(this.config(db, "maxPoolPreparedStatementPerConnectionSize")));
        dataSource.setConnectionProperties(this.config(db, "connectionProperties"));
        dataSource.setUseGlobalDataSourceStat(Boolean.parseBoolean(this.config(db, "useGlobalDataSourceStat")));
        String filters = this.config(db, "filters");
        if (!StrUtils.isNull((Object)filters)) {
            try {
                dataSource.setFilters(filters);
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        this.beanFactory.registerSingleton(beanName, (Object)dataSource);
    }

    private String config(DataSourceProperties db, String key) {
        if (StrUtils.isNull(db.getDruid())) {
            return "";
        }
        if (StrUtils.isNull((Object)db.getDruid().get(key))) {
            return this.dbProps.getDruid().get(key);
        }
        return db.getDruid().get(key);
    }

    @PostConstruct
    public void createPort() {
        Ulog.info((String)JsonUtils.toJson((Object)this.dbProps));
        this.createDataSource("dataSource", this.dbProps);
        if (this.dbProps.getOtherDatasource() != null) {
            this.dbProps.getOtherDatasource().forEach((benaName, db) -> this.createDataSource((String)benaName, (DataSourceProperties)db));
        }
    }

    public String getActive() {
        return this.active;
    }
}

