/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.test.db.imp;

import com.uniapis.logger.Ulog;
import com.uniapis.repository.config.DataSourceProperties;
import com.uniapis.repository.core.utils.RepUtils;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.test.db.IDbUnitHelper;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.UUID;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import javax.sql.DataSource;
import org.dbunit.Assertion;
import org.dbunit.DataSourceDatabaseTester;
import org.dbunit.DatabaseUnitException;
import org.dbunit.IDatabaseTester;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.database.QueryDataSet;
import org.dbunit.dataset.DataSetException;
import org.dbunit.dataset.DefaultDataSet;
import org.dbunit.dataset.IDataSet;
import org.dbunit.dataset.ITable;
import org.dbunit.dataset.ITableIterator;
import org.dbunit.dataset.excel.XlsDataSet;
import org.dbunit.dataset.filter.DefaultColumnFilter;
import org.dbunit.dataset.xml.FlatXmlDataSet;
import org.dbunit.dataset.xml.FlatXmlDataSetBuilder;
import org.dbunit.ext.mysql.MySqlDataTypeFactory;
import org.dbunit.ext.mysql.MySqlMetadataHandler;
import org.dbunit.operation.DatabaseOperation;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class DbUnitHelperImpl
implements IDbUnitHelper {
    private IDatabaseTester dbTester;
    private IDatabaseConnection con;

    @Autowired
    public DbUnitHelperImpl(@Qualifier(value="dataSource") DataSource dataSource) {
        if (this.dbTester == null) {
            DataSourceProperties dbProperties = SpringContext.getBean(DataSourceProperties.class);
            String schema = dbProperties.getUrl().substring(dbProperties.getUrl().lastIndexOf("/") + 1);
            this.dbTester = new DataSourceDatabaseTester(dataSource, schema);
        }
        try {
            this.con = this.dbTester.getConnection();
            this.con.getConfig().setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)new MySqlDataTypeFactory());
            this.con.getConfig().setProperty("http://www.dbunit.org/properties/metadataHandler", (Object)new MySqlMetadataHandler());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public File backup(String ... tableName) throws Exception {
        QueryDataSet qds = new QueryDataSet(this.con);
        for (String str : tableName) {
            qds.addTable(str);
        }
        File tempFile = File.createTempFile(UUID.shortUUID(), "xml");
        FlatXmlDataSet.write((IDataSet)qds, (Writer)new FileWriter(tempFile), (String)"UTF-8");
        return tempFile;
    }

    @Override
    public void backup(Class<?> clazz, String fileName, String ... sqls) throws Exception {
        IDataSet data = this.queryData(sqls);
        String path = System.getProperty("user.dir") + "/src/test/java/" + clazz.getPackage().getName().replaceAll("\\.", "/") + "/";
        String name = fileName;
        if (fileName.indexOf(".") > 0) {
            name = fileName.split("\\.")[0];
        }
        File xmlFile = new File(path + name + "_bak.xml");
        FlatXmlDataSet.write((IDataSet)data, (Writer)new FileWriter(xmlFile), (String)"UTF-8");
    }

    @Override
    public IDataSet getDataSet(Class<?> clazz, String fileName) throws Exception {
        String path = System.getProperty("user.dir") + "/src/test/java/" + clazz.getPackage().getName().replaceAll("\\.", "/") + "/";
        Ulog.info((String)("\u6839\u636e\u3010" + path + fileName + "\u3011\u521d\u59cb\u5316IDataSet"));
        FileInputStream is = new FileInputStream(new File(path + fileName));
        if (fileName.endsWith("xls") || fileName.endsWith("xlsx")) {
            return new XlsDataSet((InputStream)is);
        }
        FlatXmlDataSetBuilder builder = new FlatXmlDataSetBuilder();
        builder.setColumnSensing(true);
        return builder.build((InputStream)is);
    }

    @Override
    public void xls2xml(Class<?> clazz, String name, boolean initBaseClm) throws Exception {
    }

    @Override
    public void initDb(Class<?> clazz, String name) throws Exception {
        IDataSet ds = this.getDataSet(clazz, name);
        Ulog.warn((String)("\u5411[" + this.con.getConnection().getMetaData().getURL() + "]\u6570\u636e\u5e93\u4e2d\u521d\u59cb\u5316\u6570\u636e"));
        Ulog.info((String)("\u521d\u59cb\u5316\u6d89\u53ca\u7684\u8868\uff1a" + JsonUtils.toJson((Object)ds.getTableNames())));
        DatabaseOperation.CLEAN_INSERT.execute(this.con, ds);
    }

    @Override
    public IDataSet queryData(String ... sqls) throws Exception {
        QueryDataSet qds = new QueryDataSet(this.con);
        String sqlLow = "";
        int from = -1;
        int where = -1;
        for (String sql : sqls) {
            sqlLow = RepUtils.F.replaceSpace(sql.toLowerCase());
            from = sqlLow.indexOf(" from ") + 6;
            if (from < 0 || sqlLow.indexOf(" from ") < 0) {
                qds.addTable(sql);
                continue;
            }
            where = sqlLow.indexOf(" where ");
            if (where < 0) {
                where = sqlLow.length();
            }
            qds.addTable(sqlLow.substring(from, where), sql);
        }
        return qds;
    }

    @Override
    public void rollback(File tempFile) throws Exception {
        Ulog.warn((String)"\u56de\u6eda\u6570\u636e\u5e93");
        FlatXmlDataSetBuilder builder = new FlatXmlDataSetBuilder();
        builder.setColumnSensing(true);
        FlatXmlDataSet ds = builder.build((InputStream)new FileInputStream(tempFile));
        DatabaseOperation.CLEAN_INSERT.execute(this.con, (IDataSet)ds);
        tempFile.delete();
    }

    @Override
    public void dataSetEquals(IDataSet expectedDataSet, IDataSet actualDataSet, String ... excludedClm) {
        IDataSet expected = this.columnFilter4DataSet(expectedDataSet, excludedClm);
        IDataSet actual = this.columnFilter4DataSet(actualDataSet, excludedClm);
        try {
            Assertion.assertEquals((IDataSet)expected, (IDataSet)actual);
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void tableEquals(ITable expectedDataSet, ITable actualDataSet, String ... excludedClm) {
        ITable expected = this.columnFilter4Table(expectedDataSet, excludedClm);
        ITable actual = this.columnFilter4Table(actualDataSet, excludedClm);
        try {
            Assertion.assertEquals((ITable)expected, (ITable)actual);
        }
        catch (DatabaseUnitException e) {
            throw new RuntimeException(e);
        }
    }

    private IDataSet columnFilter4DataSet(IDataSet ds, String ... excludedCol) {
        try {
            ITableIterator itds = ds.iterator();
            DefaultDataSet newDs = new DefaultDataSet();
            while (itds.next()) {
                newDs.addTable(this.columnFilter4Table(itds.getTable(), excludedCol));
            }
            return newDs;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private ITable columnFilter4Table(ITable table, String ... excludedCol) {
        ArrayList<String> list = new ArrayList<String>();
        list.add("serno");
        list.add("crt_date");
        list.add("mdf_date");
        list.add("crt_user");
        list.add("mdf_user");
        list.add("patch_memo");
        for (String clm : excludedCol) {
            if (list.contains(clm)) continue;
            list.add(clm);
        }
        try {
            return DefaultColumnFilter.excludedColumnsTable((ITable)table, (String[])list.toArray(new String[0]));
        }
        catch (DataSetException e) {
            throw new RuntimeException(e);
        }
    }
}

