/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.datasource;

import com.uniapis.context.ThreadLocalContext;
import java.util.HashMap;
import java.util.Map;
import javax.sql.DataSource;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.DependsOn;
import org.springframework.jdbc.datasource.lookup.AbstractRoutingDataSource;
import org.springframework.stereotype.Component;

@Component(value="routingDataSource")
@DependsOn(value={"druidDataSourceConfig"})
@ConditionalOnProperty(name={"spring.datasource.url"})
public class RoutingDataSource
extends AbstractRoutingDataSource {
    private Map<Object, Object> targetDataSources = new HashMap<Object, Object>();

    @Autowired
    public RoutingDataSource(@Qualifier(value="dataSource") DataSource dataSource) {
        this.targetDataSources.put("dataSource", dataSource);
        super.setTargetDataSources(this.targetDataSources);
    }

    public Object determineCurrentLookupKey() {
        if (this.targetDataSources.containsKey(ThreadLocalContext.get().getDataSource())) {
            return ThreadLocalContext.get().getDataSource();
        }
        return "dataSource";
    }

    public void setTargetDataSources(Map<Object, Object> targetDataSources) {
        this.targetDataSources.putAll(targetDataSources);
        super.setTargetDataSources(this.targetDataSources);
        super.afterPropertiesSet();
    }

    public void addDataSource(Object key, Object dataSource) {
        this.targetDataSources.put(key, dataSource);
        this.setTargetDataSources(this.targetDataSources);
    }
}

