/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.core.utils;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.SqlLog;
import com.uniapis.logger.Ulog;
import com.uniapis.repository.config.DataSourceProperties;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.Function;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.group.ModelGroupBy;
import com.uniapis.repository.core.utils.ISqlUtils;
import com.uniapis.repository.core.utils.ModelFieldCache;
import com.uniapis.repository.core.utils.RepUtils;
import com.uniapis.repository.core.utils.SqlMapper;
import com.uniapis.repository.core.where.ModelWhere;
import com.uniapis.utils.ClassUtils;
import com.uniapis.utils.DateUtils;
import com.uniapis.utils.JsonUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.utils.UUID;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.springframework.data.domain.Sort;

public class SqlUtilsImpl
implements ISqlUtils {
    @Override
    public <T extends AbsModel> SqlMapper getDeleteSql(T model) {
        SqlMapper where = this.getWhere(model);
        StringBuilder delSql = StrUtils.append((String[])new String[]{"DELETE /*", this.callMethod(), "*/ FROM ", ModelFieldCache.getInstance().getTable(model.getClass()), where.getSql()});
        StringBuilder printDelSql = StrUtils.append((String[])new String[]{"DELETE /*", this.callMethod(), "*/ FROM ", ModelFieldCache.getInstance().getTable(model.getClass()), where.getPrintSql()});
        where.setSql(delSql.toString());
        where.setPrintSql(printDelSql.toString());
        return where;
    }

    @Override
    public <T extends AbsModel> SqlMapper getDeleteSql4Flag(T model) {
        SqlMapper where = this.getWhere(model);
        StringBuilder delSql = StrUtils.append((String[])new String[]{"UPDATE /*", this.callMethod(), "*/ ", ModelFieldCache.getInstance().getTable(model.getClass()), " SET data_flag = ? ", where.getSql()});
        StringBuilder printDelSql = StrUtils.append((String[])new String[]{"UPDATE /*", this.callMethod(), "*/ ", ModelFieldCache.getInstance().getTable(model.getClass()), " SET data_flag = '", "0", "' ", where.getPrintSql()});
        where.setSql(delSql.toString());
        where.setPrintSql(printDelSql.toString());
        where.getValue().add(0, "0");
        return where;
    }

    @Override
    public <T extends AbsModel> SqlMapper getInsertSql(T model) {
        SqlMapper ret = new SqlMapper();
        StringBuilder insert = StrUtils.append((String[])new String[]{"INSERT /*", this.callMethod(), "*/ INTO ", ModelFieldCache.getInstance().getTable(model.getClass())});
        Timestamp t = DateUtils.sysTimestamp();
        if (StrUtils.isNull((Object)model.getSerno())) {
            model.setSerno(UUID.shortUUID());
        }
        model.setCrtDate(t);
        model.setCrtUser(ThreadLocalContext.get().getUser().getPkUuid());
        model.setMdfDate(t);
        model.setMdfUser(ThreadLocalContext.get().getUser().getPkUuid());
        model.setDataFlag("1");
        StringBuilder field = new StringBuilder();
        StringBuilder values = new StringBuilder();
        Map<String, List<Object>> keyAndValues = this.getProperty(model);
        List<Object> keys = keyAndValues.get("key");
        for (Object key : keys) {
            StrUtils.append((StringBuilder)field, (String[])new String[]{StrUtils.trimStr((Object)key), ", "});
            StrUtils.append((StringBuilder)values, (String[])new String[]{"?, "});
        }
        if (!StrUtils.isNull((Object)field)) {
            field = new StringBuilder(field.substring(0, field.length() - 2));
            values = new StringBuilder(values.substring(0, values.length() - 2));
        }
        StrUtils.append((StringBuilder)insert, (String[])new String[]{"(", field.toString(), ") VALUES(", values.toString(), ")"});
        ret.setSql(insert.toString());
        ret.setValue(keyAndValues.get("value"));
        ret.setPrintSql(RepUtils.F.replaceSql(keyAndValues.get("value"), insert.toString(), DataSourceProperties.dbTypes()));
        return ret;
    }

    @Override
    public <T extends AbsModel> SqlMapper getUpdateSql(T model) {
        StringBuilder update = StrUtils.append((String[])new String[]{"UPDATE /*", this.callMethod(), "*/ ", ModelFieldCache.getInstance().getTable(model.getClass()), " SET"});
        model.setMdfDate(DateUtils.sysTimestamp());
        model.setMdfUser(ThreadLocalContext.get().getUser().getPkUuid());
        if (!StrUtils.isNull((Object)model.getDataFlag())) {
            model.setDataFlag(model.getDataFlag());
        } else {
            model.setDataFlag("1");
        }
        Map<String, Object> map = this.getProperty(model, true);
        for (String key : map.keySet()) {
            StrUtils.append((StringBuilder)update, (String[])new String[]{" ", key, " = ?,"});
        }
        if (StrUtils.endsWith((StringBuilder)update, (String)",")) {
            update = new StringBuilder(update.substring(0, update.length() - 1));
        }
        SqlMapper where = this.getWhere(model);
        SqlMapper ret = new SqlMapper();
        String sql = update.toString() + where.getSql();
        String printSql = update.toString() + where.getPrintSql();
        ret.setSql(sql);
        ret.getValue().addAll(map.values());
        ret.getValue().addAll(where.getValue());
        ret.setPrintSql(RepUtils.F.replaceSql(new ArrayList<Object>(map.values()), printSql, DataSourceProperties.dbTypes()));
        return ret;
    }

    @Override
    public <T extends AbsModel> SqlMapper getQuerySql(T model) {
        String groupBy = this.getGroupBy(model);
        String having = this.getHaving(model);
        String orderBy = this.getOrderBy(model);
        SqlMapper mapper = this.getWhere(model);
        StringBuilder sql = StrUtils.append((String[])new String[]{"SELECT /*", this.callMethod(), "*/ ", this.getSelect(model), " FROM ", ModelFieldCache.getInstance().getTable(model.getClass())});
        StringBuilder printSql = StrUtils.append((String[])new String[]{sql.toString(), mapper.getPrintSql(), groupBy, having, orderBy});
        StrUtils.append((StringBuilder)sql, (String[])new String[]{mapper.getSql(), groupBy, having, orderBy});
        mapper.setSql(sql.toString());
        mapper.setPrintSql(printSql.toString());
        return mapper;
    }

    @Override
    public <T extends AbsModel> SqlMapper getQuerySql4Count(T model) {
        String groupBy = this.getGroupBy(model);
        String having = this.getHaving(model);
        String orderBy = this.getOrderBy(model);
        SqlMapper where = this.getWhere(model);
        StringBuilder sql = StrUtils.append((String[])new String[]{"SELECT /*", this.callMethod(), "*/ COUNT(*) countNum FROM ", ModelFieldCache.getInstance().getTable(model.getClass())});
        StringBuilder printSql = StrUtils.append((String[])new String[]{sql.toString(), where.getPrintSql(), groupBy, having, orderBy});
        StrUtils.append((StringBuilder)sql, (String[])new String[]{where.getSql(), groupBy, having, orderBy});
        where.setSql(sql.toString());
        where.setPrintSql(printSql.toString());
        return where;
    }

    private <T extends AbsModel> SqlMapper getWhere(T model) {
        ArrayList<Collection<ModelWhere>> whereList = new ArrayList<Collection<ModelWhere>>();
        if (!model.where().getAndCriteria().isEmpty()) {
            whereList.add(model.where().getAndCriteria());
        }
        if (model.where().isCheckWhere() && whereList.isEmpty() && model.where().getOr().isEmpty() && model.where().getAnd().isEmpty()) {
            Ulog.error((String)"WHERE\u6761\u4ef6\u4e3a\u7a7a\uff01");
            throw new RuntimeException("WHERE\u6761\u4ef6\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        SqlMapper mapper = new SqlMapper();
        StringBuilder printWhere = new StringBuilder();
        StringBuilder aWhere = new StringBuilder();
        ArrayList<Object> mapperValue = new ArrayList<Object>();
        model.where().getOr().forEach((sql, values) -> {
            List<Object> list = Arrays.asList(values);
            printWhere.append("(" + RepUtils.F.replaceSql(list, (String)sql, model.where().getDbType()) + ") OR ");
            aWhere.append("(" + sql + ") OR ");
            mapperValue.addAll(list);
        });
        model.where().getAndCriteria().forEach(and -> {
            SqlMapper sql = and.getSqlMapper();
            printWhere.append(sql.getPrintSql() + " AND ");
            aWhere.append(sql.getSql() + " AND ");
            mapperValue.addAll(sql.getValue());
        });
        model.where().getAnd().forEach((sql, values) -> {
            List<Object> list = Arrays.asList(values);
            printWhere.append("(" + RepUtils.F.replaceSql(list, (String)sql, model.where().getDbType()) + ") AND ");
            aWhere.append("(" + sql + ") AND ");
            mapperValue.addAll(list);
        });
        String where = aWhere.toString();
        String printWhereSql = printWhere.toString();
        if (StrUtils.isNull((Object)aWhere)) {
            return mapper;
        }
        if (where.endsWith(" AND ")) {
            where = where.substring(0, where.length() - 5);
            printWhereSql = printWhereSql.substring(0, printWhereSql.length() - 5);
        } else {
            where = where.substring(0, where.length() - 4);
            printWhereSql = printWhereSql.substring(0, printWhereSql.length() - 4);
        }
        mapper.setSql(" WHERE " + where);
        mapper.setPrintSql(" WHERE " + printWhereSql);
        mapper.setValue(mapperValue);
        return mapper;
    }

    @Override
    public <T extends AbsModel> Map<String, Object> getProperty(T model, boolean isUpdate) {
        LinkedHashMap<String, Object> object = new LinkedHashMap<String, Object>();
        for (Field field : model.where().getChangeColumn()) {
            object.put(field.column(), "");
        }
        List<Field> fields = ModelFieldCache.getInstance().getFieldMapper(model.getClass());
        for (Field aField : fields) {
            boolean isBaseClm;
            boolean bl = isBaseClm = "data_flag".equals(aField.column()) || "mdf_date".equals(aField.column()) || "mdf_user".equals(aField.column());
            if (isUpdate && !isBaseClm && !object.keySet().contains(aField.column())) continue;
            object.put(aField.column(), ClassUtils.getProperty(model, (String)aField.property()));
        }
        return object;
    }

    @Override
    public <T extends AbsModel> Map<String, List<Object>> getProperty(T model) {
        List<Field> fields = ModelFieldCache.getInstance().getFieldMapper(model.getClass());
        ArrayList<Object> valueObj = new ArrayList<Object>(fields.size());
        ArrayList<String> keyObj = new ArrayList<String>(fields.size());
        for (Field aField : fields) {
            keyObj.add(aField.column());
            valueObj.add(ClassUtils.getProperty(model, (String)aField.property()));
        }
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>(2);
        map.put("value", valueObj);
        map.put("key", keyObj);
        return map;
    }

    private <T extends AbsModel> String getSelect(T model) {
        List<Field> select = model.getSelect();
        if (!select.isEmpty()) {
            StringBuilder sb = new StringBuilder();
            select.forEach(field -> sb.append(field.column()).append(", "));
            return sb.substring(0, sb.length() - 2);
        }
        GroupBy groupBy = model.groupBy();
        if (groupBy.by().isEmpty() && groupBy.group().isEmpty()) {
            return "*";
        }
        String by = this.getBy(model);
        String group = this.getGroup(model);
        if (StrUtils.isNull((Object)group)) {
            return by;
        }
        if (!StrUtils.isNull((Object)by)) {
            return by + ", " + group;
        }
        return group;
    }

    private <T extends AbsModel> String getOrderBy(T model) {
        Sort.Order[] orders = model.getOrderBy();
        if (orders == null || orders.length == 0) {
            return "";
        }
        String orderBy = "";
        for (Sort.Order order : orders) {
            orderBy = orderBy + ", " + order.getProperty() + " " + order.getDirection().toString();
        }
        if (!StrUtils.isNull((Object)orderBy)) {
            orderBy = orderBy.substring(2);
        }
        return " ORDER BY " + orderBy;
    }

    private <T extends AbsModel> String getGroupBy(T model) {
        GroupBy groupBy = model.groupBy();
        if (groupBy.by().isEmpty()) {
            return "";
        }
        return " GROUP BY " + this.getBy(model);
    }

    private <T extends AbsModel> String getHaving(T model) {
        GroupBy groupBy = model.groupBy();
        if (groupBy.group().isEmpty()) {
            return "";
        }
        StringBuilder fields = new StringBuilder();
        List<ModelGroupBy> groupList = groupBy.group();
        for (ModelGroupBy modelGroupBy : groupList) {
            if (modelGroupBy.getHavingFlag() == null) continue;
            StrUtils.append((StringBuilder)fields, (String[])new String[]{modelGroupBy.getHavingSql(), " AND "});
        }
        if (StrUtils.isNull((Object)fields)) {
            return "";
        }
        return " HAVING " + fields.substring(0, fields.length() - 5);
    }

    private <T extends AbsModel> String getBy(T model) {
        GroupBy groupBy = model.groupBy();
        if (groupBy.by().isEmpty()) {
            return "";
        }
        StringBuilder fields = new StringBuilder();
        Set<Field> fieldList = groupBy.by();
        for (Field aField : fieldList) {
            StrUtils.append((StringBuilder)fields, (String[])new String[]{aField.column(), ", "});
        }
        if (!StrUtils.isNull((Object)fields)) {
            return fields.substring(0, fields.length() - 2);
        }
        return fields.toString();
    }

    private <T extends AbsModel> String getGroup(T model) {
        GroupBy groupBy = model.groupBy();
        if (groupBy.group().isEmpty()) {
            return "";
        }
        StringBuilder fields = new StringBuilder();
        List<ModelGroupBy> groupList = groupBy.group();
        for (ModelGroupBy modelGroupBy : groupList) {
            if (Function.COUNT_DISTINCT.equals((Object)modelGroupBy.getFunction())) {
                StrUtils.append((StringBuilder)fields, (String[])new String[]{"COUNT(DISTINCT ", modelGroupBy.getField().column(), ") AS ", modelGroupBy.getFunction().toString().toLowerCase(), "_", modelGroupBy.getField().column(), ", "});
                continue;
            }
            StrUtils.append((StringBuilder)fields, (String[])new String[]{modelGroupBy.getFunction().toString(), "(", modelGroupBy.getField().column(), ") AS ", modelGroupBy.getFunction().toString().toLowerCase(), "_", modelGroupBy.getField().column(), ", "});
        }
        if (!StrUtils.isNull((Object)fields)) {
            return fields.substring(0, fields.length() - 2);
        }
        return fields.toString();
    }

    @Override
    public final void annalLog(String result, long startTime, Object data, String type) {
        this.annalLog(result, startTime, data, type, null);
    }

    @Override
    public final void annalLog(String result, long startTime, Object data, String type, Supplier<String> sql) {
        if (sql != null && ThreadLocalContext.get() != null) {
            SqlLog.info((String)(sql.get() + " [" + StrUtils.trimStr((Object)ThreadLocalContext.get().getDataSourceName()) + "]"));
        }
        String jsonData = "";
        if (ThreadLocalContext.get() != null && Ulog.getLogLevel().intLevel() > Level.WARN.intLevel()) {
            jsonData = JsonUtils.toJson((Object)data);
        }
        SqlLog.info((String)("\u7528\u65f6[" + (double)(System.currentTimeMillis() - startTime) / 1000.0 + "]\u79d2," + type + "[" + result + "]\u6761\u8bb0\u5f55=" + jsonData));
    }

    private String callMethod() {
        StackTraceElement[] exception = Thread.currentThread().getStackTrace();
        String className = "";
        String[] classAttr = null;
        for (StackTraceElement ste : exception) {
            className = ste.toString();
            classAttr = (className = className.substring(className.indexOf("(") + 1, className.indexOf(")"))).split("\\.");
            if (Ulog.excludeClass.contains(classAttr[0])) continue;
            return className;
        }
        return className;
    }
}

