/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.core.utils;

import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SqlSafeUtils {
    private static final String SQL_TYPES = "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR";
    private static final String[] SQL_REGEXPS = new String[]{"(?i)(.*)(\\b)+(OR|AND)(\\s)+(true|false)(\\s)*(.*)", "(?i)(.*)(\\b)+(OR|AND)(\\s)+(\\w)(\\s)*(\\=)(\\s)*(\\w)(\\s)*(.*)", "(?i)(.*)(\\b)+(OR|AND)(\\s)+(equals|not equals)(\\s)+(true|false)(\\s)*(.*)", "(?i)(.*)(\\b)+(OR|AND)(\\s)+([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(\\=)(\\s)*([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(.*)", "(?i)(.*)(\\b)+(OR|AND)(\\s)+([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(\\!\\=)(\\s)*([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(.*)", "(?i)(.*)(\\b)+(OR|AND)(\\s)+([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(\\<\\>)(\\s)*([0-9A-Za-z_'][0-9A-Za-z\\d_']*)(\\s)*(.*)", "(?i)(.*)(\\b)+SELECT(\\b)+\\s.*(\\b)(.*)", "(?i)(.*)(\\b)+INSERT(\\b)+\\s.*(\\b)+INTO(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+UPDATE(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+DELETE(\\b)+\\s.*(\\b)+FROM(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+UPSERT(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+SAVEPOINT(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+CALL(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+ROLLBACK(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+KILL(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+DROP(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+CREATE(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+ALTER(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+TRUNCATE(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+LOCK(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+UNLOCK(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+RELEASE(\\b)+(\\s)*(" + "TABLE, TABLESPACE, PROCEDURE, FUNCTION, TRIGGER, KEY, VIEW, MATERIALIZED VIEW, LIBRARYDATABASE LINK, DBLINK, INDEX, CONSTRAINT, TRIGGER, USER, SCHEMA, DATABASE, PLUGGABLE DATABASE, BUCKET, CLUSTER, COMMENT, SYNONYM, TYPE, JAVA, SESSION, ROLE, PACKAGE, PACKAGE BODY, OPERATORSEQUENCE, RESTORE POINT, PFILE, CLASS, CURSOR, OBJECT, RULE, USER, DATASET, DATASTORE, COLUMN, FIELD, OPERATOR".replaceAll(",", "|") + ")(\\b)+\\s.*(.*)", "(?i)(.*)(\\b)+DESC(\\b)+(\\w)*\\s.*(.*)", "(?i)(.*)(\\b)+DESCRIBE(\\b)+(\\w)*\\s.*(.*)", "(.*)(/\\*|\\*/|;){1,}(.*)", "(.*)(-){2,}(.*)"};
    private static final List<Pattern> VALIDATION_PATTERNS = SqlSafeUtils.buildPatterns(SQL_REGEXPS);

    public static boolean isSqlInjectionSafe(String dataString) {
        if (SqlSafeUtils.isEmpty(dataString)) {
            return true;
        }
        for (Pattern pattern : VALIDATION_PATTERNS) {
            if (!SqlSafeUtils.matches(pattern, dataString)) continue;
            return false;
        }
        return true;
    }

    private static boolean matches(Pattern pattern, String dataString) {
        Matcher matcher = pattern.matcher(dataString);
        return matcher.matches();
    }

    private static List<Pattern> buildPatterns(String[] expressionStrings) {
        ArrayList<Pattern> patterns = new ArrayList<Pattern>();
        for (String expression : expressionStrings) {
            patterns.add(SqlSafeUtils.getPattern(expression));
        }
        return patterns;
    }

    private static Pattern getPattern(String regEx) {
        return Pattern.compile(regEx, 66);
    }

    private static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static void main(String[] args) {
        String sql = " 1=1 and 2=2";
        if (SqlSafeUtils.isSqlInjectionSafe(sql)) {
            System.out.println(sql + "\u65e0sql\u6ce8\u5165\u98ce\u9669");
        } else {
            System.out.println(sql + "\u6709sql\u6ce8\u5165\u98ce\u9669");
        }
        sql = " create table";
        if (SqlSafeUtils.isSqlInjectionSafe(sql)) {
            System.out.println(sql + "\u65e0sql\u6ce8\u5165\u98ce\u9669");
        } else {
            System.out.println(sql + "\u6709sql\u6ce8\u5165\u98ce\u9669");
        }
    }
}

