/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.repository.core.utils;

import com.uniapis.repository.core.Field;
import com.uniapis.utils.StrUtils;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.Column;
import javax.persistence.Table;

public class ModelFieldCache {
    private static ModelFieldCache fieldCache = null;
    private Map<String, List<Field>> fieldMapperCache = new HashMap<String, List<Field>>();
    private Map<String, Map<String, String>> fieldMapCache = new HashMap<String, Map<String, String>>();
    private Map<String, String> tableMapperCache = new HashMap<String, String>();
    private static final String FIELD_KEY = "FIELD";
    private static final String TABLE_KEY = "TABLE";

    public String getTable(Class<?> elementType) {
        if (!StrUtils.isNull((Object)this.tableMapperCache.get(elementType + TABLE_KEY))) {
            return this.tableMapperCache.get(elementType + TABLE_KEY);
        }
        Table tArray = elementType.getDeclaredAnnotation(Table.class);
        if (tArray == null) {
            return "";
        }
        this.tableMapperCache.put(elementType + TABLE_KEY, tArray.name());
        return this.tableMapperCache.get(elementType + TABLE_KEY);
    }

    public String getField(Class<?> elementType, String column) {
        this.getFieldMapper(elementType);
        return this.fieldMapCache.get(elementType + FIELD_KEY).get(column);
    }

    public List<Field> getFieldMapper(Class<?> elementType) {
        if (this.fieldMapperCache.get(elementType + FIELD_KEY) != null) {
            return this.fieldMapperCache.get(elementType + FIELD_KEY);
        }
        ArrayList<Field> fieldMapper = new ArrayList<Field>();
        HashMap<String, String> fieldMap = new HashMap<String, String>();
        ArrayList<java.lang.reflect.Field> fields = new ArrayList<java.lang.reflect.Field>();
        fields.addAll(Arrays.asList(elementType.getDeclaredFields()));
        fields.addAll(Arrays.asList(elementType.getSuperclass().getDeclaredFields()));
        for (java.lang.reflect.Field field : fields) {
            Column columnAnnotaion = field.getAnnotation(Column.class);
            if (columnAnnotaion == null) continue;
            fieldMapper.add(new Field(field.getName(), columnAnnotaion.name()));
            fieldMap.put(columnAnnotaion.name(), field.getName());
        }
        Collections.sort(fieldMapper);
        this.fieldMapperCache.put(elementType + FIELD_KEY, fieldMapper);
        this.fieldMapCache.put(elementType + FIELD_KEY, fieldMap);
        return this.fieldMapperCache.get(elementType + FIELD_KEY);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ModelFieldCache getInstance() {
        if (fieldCache != null) {
            return fieldCache;
        }
        String string = FIELD_KEY;
        synchronized (FIELD_KEY) {
            if (fieldCache == null) {
                fieldCache = new ModelFieldCache();
            }
            // ** MonitorExit[var0] (shouldn't be in output)
            return fieldCache;
        }
    }

    private ModelFieldCache() {
    }

    public static void main(String[] args) {
        System.out.println(ModelFieldCache.class + "__");
    }
}

