/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.logger;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.uniapis.logger.Ulog;
import java.io.IOException;
import java.io.InputStream;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import java.util.stream.Collectors;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.PathResource;
import org.yaml.snakeyaml.Yaml;

public class LoggerUtils {
    public static final String[] CHARS = new String[]{"a", "b", "c", "d", "e", "f", "g", "h", "i", "j", "k", "l", "m", "n", "o", "p", "q", "r", "s", "t", "u", "v", "w", "x", "y", "z", "0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "A", "B", "C", "D", "E", "F", "G", "H", "I", "J", "K", "L", "M", "N", "O", "P", "Q", "R", "S", "T", "U", "V", "W", "X", "Y", "Z"};
    private static final String NULL = "null";
    private static Map<String, Map> ymlConfig = new HashMap<String, Map>();

    public static String shortUUID() {
        StringBuilder shortBuffer = new StringBuilder();
        String uuid = UUID.randomUUID().toString().replace("-", "");
        for (int i = 0; i < 8; ++i) {
            String str = uuid.substring(i * 4, i * 4 + 4);
            int x = Integer.parseInt(str, 16);
            shortBuffer.append(CHARS[x % 62]);
        }
        return shortBuffer.toString();
    }

    public static String toJson(Object obj) {
        if (obj == null) {
            return "";
        }
        try {
            ObjectMapper mapper = LoggerUtils.initObjectMapper(true);
            return mapper.writeValueAsString(obj);
        }
        catch (JsonProcessingException e) {
            throw new RuntimeException(e);
        }
    }

    public static Map<String, Object> json2Map(String json) {
        if (LoggerUtils.isNull(json)) {
            return new HashMap<String, Object>();
        }
        try {
            ObjectMapper mapper = LoggerUtils.initObjectMapper(true);
            return (Map)mapper.readValue(json, (JavaType)mapper.getTypeFactory().constructMapType(Map.class, String.class, Object.class));
        }
        catch (Exception e) {
            Ulog.error(json);
            throw new RuntimeException(e);
        }
    }

    public static ObjectMapper initObjectMapper(boolean isFormatTimestamps) {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.WRAP_EXCEPTIONS, false);
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(DeserializationFeature.ACCEPT_EMPTY_STRING_AS_NULL_OBJECT, true);
        mapper.setTimeZone(TimeZone.getDefault());
        if (isFormatTimestamps) {
            mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
            SimpleDateFormat d = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
            mapper.setDateFormat((DateFormat)d);
        }
        mapper.getSerializerProvider().setNullValueSerializer((JsonSerializer)new JsonSerializer<Object>(){

            public void serialize(Object arg0, JsonGenerator arg1, SerializerProvider arg2) throws IOException, JsonProcessingException {
                arg1.writeString("");
            }
        });
        return mapper;
    }

    public static boolean isNull(Object obj) {
        return obj == null || "".equals(obj) || NULL.equals(obj.toString().toLowerCase());
    }

    public static String trimStr(Object str) {
        if (str == null || "".equals(str) || NULL.equals(str.toString().toLowerCase())) {
            return "";
        }
        if (str instanceof String) {
            return str.toString().trim();
        }
        return str.toString().trim();
    }

    public static String date2String(Date date, String fmt) {
        SimpleDateFormat clsFormat = new SimpleDateFormat(fmt);
        return clsFormat.format(date);
    }

    public static Map<?, ?> loadYml(String fileName) {
        if (ymlConfig.containsKey(fileName)) {
            return ymlConfig.get(fileName);
        }
        Yaml yaml = new Yaml();
        try {
            String path;
            PathResource resource;
            ClassPathResource configFile = new ClassPathResource(fileName);
            HashMap param = new HashMap();
            if (configFile.exists()) {
                Map file = (Map)yaml.loadAs(configFile.getInputStream(), Map.class);
                param.putAll(file);
                System.out.println("\u3010" + fileName + "\u3011= " + LoggerUtils.toJson(file));
            }
            if ((resource = new PathResource(path = LoggerUtils.getJarPath() + fileName)).exists()) {
                Map file = (Map)yaml.loadAs(resource.getInputStream(), Map.class);
                System.out.println("jar\u5305\u540c\u76ee\u5f55\u3010" + fileName + "\u3011= " + LoggerUtils.toJson(file));
                LoggerUtils.deepCloneMap(param, file);
            }
            if (!configFile.exists() && !resource.exists()) {
                System.out.println("\u672a\u67e5\u627e\u5230\u3010" + fileName + "\u3011\u914d\u7f6e\u6587\u4ef6\uff0curl\u5bf9\u5e94\u6587\u4ef6\u4e0d\u5b58\u5728");
            }
            if (param.isEmpty()) {
                return null;
            }
            if (configFile.exists() && resource.exists()) {
                System.out.println(" \u5e76\u96c6\u3010" + fileName + "\u3011= " + LoggerUtils.toJson(param));
            }
            ymlConfig.put(fileName, param);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return ymlConfig.get(fileName);
    }

    private static InputStream getResourceInputStream(String fileName) throws IOException {
        PathResource resource = new PathResource(LoggerUtils.getJarPath() + fileName);
        if (resource.exists()) {
            return resource.getInputStream();
        }
        ClassPathResource configFile = new ClassPathResource(fileName);
        if (configFile.exists()) {
            return configFile.getInputStream();
        }
        System.out.println("\u672a\u67e5\u627e\u5230\u3010" + fileName + "\u3011\u914d\u7f6e\u6587\u4ef6\uff0curl\u5bf9\u5e94\u6587\u4ef6\u4e0d\u5b58\u5728");
        return null;
    }

    private static String getJarPath() {
        String userDir = System.getProperty("user.dir");
        String classPath = LoggerUtils.getClassPath();
        String path = userDir + "/" + classPath;
        path = path.replaceAll("//", "/");
        path = path.substring(0, path.lastIndexOf("/"));
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        for (String dir : path.split("/")) {
            set.add(dir);
        }
        return set.stream().collect(Collectors.joining("/")) + "/";
    }

    private static String getClassPath() {
        String classPath = System.getProperty("java.class.path");
        if (classPath.contains("charsets.jar") && classPath.contains("deploy.jar")) {
            return "";
        }
        return classPath.replace(".", "");
    }

    public static Object readYmlValue(String fileName, String prefix) {
        Map<?, ?> map = LoggerUtils.loadYml(fileName);
        return LoggerUtils.getValue(map, prefix);
    }

    public static Object getValue(Map<?, ?> map, String prefix) {
        if (map == null) {
            return "";
        }
        int index = prefix.indexOf(".");
        if (index < 0) {
            return map.get(prefix);
        }
        Object obj = map.get(prefix.substring(0, index));
        if (obj == null) {
            return null;
        }
        if (!(obj instanceof Map)) {
            return obj;
        }
        return LoggerUtils.getValue((Map)obj, prefix.substring(index + 1));
    }

    private static Map deepCloneMap(Map target, Map source) {
        if (source == null) {
            return target;
        }
        if (target == null) {
            return source;
        }
        for (Object key : source.keySet()) {
            Object value = source.get(key);
            if (value instanceof Map) {
                if (target.get(key) == null) {
                    target.put(key, new HashMap());
                }
                LoggerUtils.deepCloneMap((Map)target.get(key), (Map)value);
                continue;
            }
            if (value instanceof List) {
                if (target.get(key) == null) {
                    target.put(key, new ArrayList());
                }
                List l = (List)target.get(key);
                l.retainAll((List)source.get(key));
                continue;
            }
            target.put(key, source.get(key));
        }
        return target;
    }
}

