/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.logger;

import com.uniapis.logger.LoggerUtils;
import java.io.File;
import java.net.Inet4Address;
import java.net.InterfaceAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class Env {
    private static Env env = null;
    private final String LOGGER_LOG_MAX_LENGTH = "uniapis.logger.logMaxLength";
    private final String UNIAPIS_BASE_DIAR = "uniapis.baseDir";
    private final String UNIAPIS_EXCLUDE_FIELDS = "uniapis.excludeFields";
    private final String UNIAPIS_SQL_FORMAT = "uniapis.sqlFormat";
    private final String SPTIRNG_APPLICATION_NAME = "spring.application.name";
    private final String UNIAPIS_MACHINEID = "uniapis.machineId";
    private String rootDir = "";
    private int logMaxLength = 258;
    private String applicationName = "";
    private String excludeFields = "";
    private String sqlFormat = "";
    private String machineId = "";
    private final String WINDOWS = "Windows";

    public static Env env() {
        if (env == null) {
            env = new Env();
        }
        return env;
    }

    public Env() {
        System.setProperty("ip", Env.ip());
        this.machineId = Env.machineId(System.getProperty("ip"));
        System.out.println("\u6839\u636eIP\u8ba1\u7b97\u7684\u673a\u5668ID=" + this.machineId);
        this.initUniApisConfig("/config/logger-default-exclude-class.yml");
        this.initUniApisConfig("/config/uniapis-bootstrap.yml");
        this.initSpringConfig("bootstrap.yml");
        this.initSpringConfig("/config/application.yml");
        this.initSpringConfig();
    }

    private static String ip() {
        String ipStr;
        StringBuilder ip = new StringBuilder();
        try {
            Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
            while (e.hasMoreElements()) {
                NetworkInterface item = e.nextElement();
                if (item.isVirtual() || !item.isUp() || item.isLoopback()) continue;
                for (InterfaceAddress address : item.getInterfaceAddresses()) {
                    if (!(address.getAddress() instanceof Inet4Address)) continue;
                    ip.append(address.getAddress().getHostAddress() + ",");
                }
            }
        }
        catch (SocketException e) {
            // empty catch block
        }
        if ((ipStr = ip.toString()).endsWith(",")) {
            return ipStr.substring(0, ipStr.length() - 1);
        }
        return ipStr;
    }

    private void initUniApisConfig(String fileName) {
        Map<?, ?> obj = LoggerUtils.loadYml(fileName);
        if (obj == null) {
            return;
        }
        this.initUniApisConfig(obj);
    }

    private void initUniApisConfig(Map obj) {
        Object value = LoggerUtils.getValue(obj, this.UNIAPIS_BASE_DIAR);
        if (value != null && value instanceof String) {
            File f = new File(value.toString());
            String path = f.getPath().endsWith(File.separator) ? f.getPath() : f.getPath() + File.separator;
            String osName = System.getProperty("os.name");
            this.rootDir = osName.contains("Windows") ? "C:/" + path : path;
            System.out.println("\u6839\u76ee\u5f55\u4e3a:" + this.rootDir);
        }
        if ((value = LoggerUtils.getValue(obj, this.LOGGER_LOG_MAX_LENGTH)) != null && value instanceof Integer) {
            this.logMaxLength = (Integer)value;
            System.out.println("console\u663e\u793a\u65e5\u5fd7\u6700\u957f\u957f\u5ea6\u4e3a:" + this.logMaxLength);
        }
        if ((value = LoggerUtils.getValue(obj, this.UNIAPIS_EXCLUDE_FIELDS)) != null && value instanceof String) {
            this.excludeFields = value.toString();
            System.out.println("\u6392\u9664\u5b57\u6bb5\u4e3a:" + this.excludeFields);
        }
        if ((value = LoggerUtils.getValue(obj, this.UNIAPIS_SQL_FORMAT)) != null && value instanceof String) {
            this.sqlFormat = value.toString().toUpperCase(Locale.ROOT);
            System.out.println("SQL\u683c\u5f0f\u5316\u4e3a:" + this.sqlFormat);
        }
        if (!LoggerUtils.isNull(value = LoggerUtils.getValue(obj, this.UNIAPIS_MACHINEID)) && value instanceof String) {
            this.machineId = value.toString();
            System.out.println("\u914d\u7f6e\u6587\u4ef6\u4e2d\u53d6\u51fa\u7684\u673a\u5668ID\u4e3a:" + this.machineId);
        }
    }

    private void initSpringConfig(String fileName) {
        Map<?, ?> obj = LoggerUtils.loadYml(fileName);
        if (obj == null) {
            return;
        }
        Object value = LoggerUtils.getValue(obj, this.SPTIRNG_APPLICATION_NAME);
        if (LoggerUtils.isNull(this.applicationName) && !LoggerUtils.isNull(value) && value instanceof String) {
            this.applicationName = value.toString();
            System.out.println("\u5e94\u7528\u540d\u4e3a:" + this.applicationName);
        }
        this.initUniApisConfig(obj);
    }

    private void initSpringConfig() {
        if (!LoggerUtils.isNull(this.applicationName)) {
            return;
        }
        URL url = Env.class.getClassLoader().getResource("/config/uniapis-bootstrap.yml");
        if (url == null) {
            return;
        }
        String path = url.getPath();
        if (LoggerUtils.isNull(path)) {
            return;
        }
        if (LoggerUtils.isNull(path = path.substring(0, path.indexOf(".jar")))) {
            return;
        }
        this.applicationName = path = path.substring(path.lastIndexOf("/") + 1, path.length());
    }

    public String baseDir() {
        return this.rootDir;
    }

    public int logMaxLength() {
        return this.logMaxLength;
    }

    public String appName() {
        return this.applicationName;
    }

    public String sqlFormat() {
        return this.sqlFormat;
    }

    public String machineId() {
        return this.machineId;
    }

    public List<String> excludeFields() {
        if (LoggerUtils.isNull(this.excludeFields)) {
            return new ArrayList<String>();
        }
        return new ArrayList<String>(Arrays.asList(this.excludeFields.split(",")));
    }

    private static String machineId(String ip) {
        String[] ipArray = ip.split(",")[0].split("\\.");
        int machineId = 0;
        for (int i = 1; i <= 4; ++i) {
            machineId += Integer.parseInt(ipArray[i - 1]) * i;
        }
        String binary = Integer.toBinaryString(machineId);
        if (binary.length() > 10) {
            binary = binary.substring(binary.length() - 10);
        }
        return Long.parseLong(binary, 2) + "";
    }
}

