/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.logger;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Console;
import com.uniapis.logger.ErrorLogger;
import com.uniapis.logger.ErrorLoggerWrite;
import com.uniapis.logger.LoggerCacheManager;
import com.uniapis.logger.LoggerExtend;
import com.uniapis.logger.LoggerMasking;
import com.uniapis.logger.LoggerUtils;
import com.uniapis.logger.impl.LoggerExtendImpl;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.ThreadContext;

public class Ulog {
    private static final Logger logger = LogManager.getLogger();
    public static List<String> excludeClass = new ArrayList<String>();
    private static boolean SIMPLE_LOGGER = true;
    public static final String LOG_FLAG = "uniapis-redis-log4j2-flag";
    static LoggerCacheManager cacheManager;
    private static LoggerExtend loggerExtend;
    private static LoggerMasking masking;
    private static final String TRUE = "true";
    private static final String EXCLUDE_CLASS = "uniapis.logger.excludeClass";
    private static final String LOGGER_SIMPLE_PATH = "uniapis.logger.simple";

    public static void error(String e) {
        Ulog.error(() -> e);
    }

    public static void error(Throwable e) {
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            e.printStackTrace(pw);
            String s = sw.toString();
            Ulog.error(s);
            e.printStackTrace();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    public static void error(Object e) {
        Ulog.error(() -> LoggerUtils.toJson(e));
    }

    public static void error(Supplier<String> e) {
        if (Ulog.getLogLevel().intLevel() < Level.ERROR.intLevel()) {
            return;
        }
        String msg = e.get();
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        if (Ulog.getMasking() != null) {
            msg = Ulog.getMasking().masking(msg);
        }
        String call = " " + Ulog.callMethod();
        logger.error(msg + call);
        Console.error(msg, call);
        Ulog.addMsg(msg);
        ErrorLogger.addToDBRqst(ThreadLocalContext.get().getThreadUUID());
    }

    public static void debug(String message) {
        Ulog.debug(() -> message);
    }

    public static void debug(Object message) {
        Ulog.debug(() -> LoggerUtils.toJson(message));
    }

    public static void debug(Supplier<String> message) {
        if (Ulog.getLogLevel().intLevel() < Level.DEBUG.intLevel()) {
            return;
        }
        String msg = message.get();
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        if (Ulog.getMasking() != null) {
            msg = Ulog.getMasking().masking(msg);
        }
        msg = msg + " " + Ulog.callMethod();
        logger.debug(msg);
        Ulog.addMsg(msg);
    }

    public static void info(String message) {
        Ulog.info(() -> message);
    }

    public static void info(Object message) {
        Ulog.info(() -> {
            if (message instanceof String) {
                return (String)message;
            }
            if (message instanceof StringBuilder) {
                return message.toString();
            }
            return LoggerUtils.toJson(message);
        });
    }

    public static void info(Supplier<String> message) {
        Ulog.info(message, logger);
    }

    static void info(Supplier<String> message, Logger logger) {
        Ulog.info(message, logger, true);
    }

    static void info(Supplier<String> message, Logger logger, boolean showClassName) {
        if (logger.getLevel().intLevel() < Level.INFO.intLevel()) {
            return;
        }
        String msg = message.get();
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        if (Ulog.getMasking() != null) {
            msg = Ulog.getMasking().masking(msg);
        }
        String call = " " + Ulog.callMethod(showClassName);
        logger.info(msg + call);
        Console.info(msg, call);
        Ulog.addMsg(msg + call);
    }

    public static void warn(String message) {
        Ulog.warn(() -> message);
    }

    public static void warn(Object message) {
        Ulog.warn(() -> LoggerUtils.toJson(message));
    }

    public static void warn(Supplier<String> message) {
        if (Ulog.getLogLevel().intLevel() < Level.WARN.intLevel()) {
            return;
        }
        String msg = message.get();
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        if (Ulog.getMasking() != null) {
            msg = Ulog.getMasking().masking(msg);
        }
        String call = " " + Ulog.callMethod();
        Console.warn(msg, call);
        logger.warn(msg + call);
        Ulog.addMsg(msg + call);
    }

    public static Level getLogLevel() {
        return logger.getLevel();
    }

    public static String callMethod() {
        return Ulog.callMethod(true);
    }

    public static String callMethod(boolean showClassName) {
        String extendInfo;
        if (!LoggerUtils.isNull(ThreadContext.get((String)LOG_FLAG)) && TRUE.equals(ThreadContext.get((String)LOG_FLAG).toLowerCase())) {
            return "";
        }
        String string = extendInfo = loggerExtend != null ? loggerExtend.extendInfo() : "";
        if (!showClassName) {
            return extendInfo;
        }
        StackTraceElement[] exception = Thread.currentThread().getStackTrace();
        String className = "";
        String[] classAttr = null;
        for (StackTraceElement ste : exception) {
            className = ste.toString();
            classAttr = (className = className.substring(className.indexOf("(") + 1, className.indexOf(")"))).split("\\.");
            if (excludeClass.contains(classAttr[0])) continue;
            return className + " " + extendInfo;
        }
        return extendInfo;
    }

    public static void setLoggerExtend(LoggerExtend loggerExtend) {
        Ulog.loggerExtend = loggerExtend;
    }

    public static LoggerCacheManager getCacheManager() {
        return cacheManager;
    }

    public static void setCacheManager(LoggerCacheManager cacheManager) {
        Ulog.cacheManager = cacheManager;
    }

    public static void setErrorLoggerWrite(ErrorLoggerWrite write) {
        ErrorLogger.setWrite(write);
    }

    public static ErrorLoggerWrite getErrorLoggerWrite() {
        return ErrorLogger.getWrite();
    }

    static void addMsg(String msg) {
        if (SIMPLE_LOGGER) {
            return;
        }
        if (cacheManager == null) {
            return;
        }
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        if (LoggerUtils.isNull(ThreadLocalContext.get().getThreadUUID())) {
            ThreadLocalContext.get().setThreadUUID(LoggerUtils.shortUUID());
        }
        ErrorLogger.addMsg(ThreadLocalContext.get().getThreadUUID(), LoggerUtils.date2String(new Date(), "yyyy-MM-dd HH:mm:ss.SSSSSS") + " " + msg);
    }

    public static boolean isSimpleLogger() {
        return SIMPLE_LOGGER;
    }

    private static void initLoggerSimpleValue(Object value) {
        if (LoggerUtils.isNull(value)) {
            return;
        }
        if (value instanceof String) {
            SIMPLE_LOGGER = Boolean.valueOf(value.toString());
        }
        if (value instanceof Boolean) {
            SIMPLE_LOGGER = (Boolean)value;
        }
        System.out.println("uniapis.logger.simple = " + SIMPLE_LOGGER);
    }

    public static LoggerMasking getMasking() {
        return masking;
    }

    public static void setMasking(LoggerMasking masking) {
        Ulog.masking = masking;
    }

    static {
        loggerExtend = new LoggerExtendImpl();
        Object value = LoggerUtils.readYmlValue("/config/logger-default-exclude-class.yml", EXCLUDE_CLASS);
        if (value != null && value instanceof List) {
            excludeClass.addAll((List)value);
        }
        if ((value = LoggerUtils.readYmlValue("/config/uniapis-bootstrap.yml", EXCLUDE_CLASS)) != null && value instanceof List) {
            excludeClass.addAll((List)value);
        }
        value = LoggerUtils.readYmlValue("/config/uniapis-bootstrap.yml", LOGGER_SIMPLE_PATH);
        Ulog.initLoggerSimpleValue(value);
        Object bootValue = LoggerUtils.readYmlValue("/config/bootstrap.yml", LOGGER_SIMPLE_PATH);
        if (!LoggerUtils.isNull(bootValue)) {
            Ulog.initLoggerSimpleValue(bootValue);
        } else {
            bootValue = LoggerUtils.readYmlValue("/bootstrap.yml", LOGGER_SIMPLE_PATH);
            Ulog.initLoggerSimpleValue(bootValue);
        }
        Object appValue = LoggerUtils.readYmlValue("/config/application.yml", LOGGER_SIMPLE_PATH);
        if (!LoggerUtils.isNull(appValue)) {
            Ulog.initLoggerSimpleValue(appValue);
        } else {
            appValue = LoggerUtils.readYmlValue("/application.yml", LOGGER_SIMPLE_PATH);
            Ulog.initLoggerSimpleValue(appValue);
        }
    }
}

