/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.logger;

import com.uniapis.context.ThreadLocalContext;
import com.uniapis.logger.Env;
import com.uniapis.logger.ErrorLoggerWrite;
import com.uniapis.logger.LoggerUtils;
import com.uniapis.logger.Ulog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.regex.Pattern;

public class ErrorLogger
implements Runnable {
    private static Set<String> TODB_LIST = new ConcurrentSkipListSet<String>();
    private static ErrorLoggerWrite write;
    private static final String URL_PATTERN = "[A-Za-z0-9_/.-]+";

    public static void addMsg(String threadUUID, String msg) {
        if (Ulog.cacheManager == null || Ulog.isSimpleLogger()) {
            return;
        }
        if (LoggerUtils.isNull(threadUUID)) {
            return;
        }
        String cacheFuncId = LoggerUtils.trimStr(Ulog.cacheManager.getUrl(threadUUID));
        String funcId = ThreadLocalContext.get().getUser().getUrl();
        if (LoggerUtils.isNull(cacheFuncId) || !cacheFuncId.equals(funcId)) {
            Ulog.cacheManager.putMessage(threadUUID, 0L, funcId);
        }
        Ulog.cacheManager.putMessage(threadUUID, Ulog.cacheManager.getCacheSize(threadUUID) + 1L, msg);
        Ulog.cacheManager.expire(threadUUID, 300L);
    }

    public static void removeMsg(String threadUUID) {
        if (Ulog.cacheManager == null || Ulog.isSimpleLogger()) {
            return;
        }
        if (!TODB_LIST.contains(threadUUID)) {
            Ulog.cacheManager.delMessage(threadUUID);
        }
    }

    public static void addToDBRqst(String threadUUID) {
        if (LoggerUtils.isNull(threadUUID) || Ulog.isSimpleLogger()) {
            return;
        }
        TODB_LIST.add(threadUUID);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        if (Ulog.cacheManager == null || write == null || Ulog.isSimpleLogger()) {
            return;
        }
        Set<String> set = TODB_LIST;
        synchronized (set) {
            ArrayList<String> removeList = new ArrayList<String>();
            ArrayList<String> threadList = new ArrayList<String>();
            threadList.addAll(TODB_LIST);
            for (String threadUUID : threadList) {
                Map<String, String> msgList = Ulog.cacheManager.getMessage(threadUUID);
                if (msgList == null || msgList.isEmpty()) continue;
                String url = (String)msgList.get("0");
                if (!Pattern.matches(URL_PATTERN, url)) {
                    url = "";
                } else {
                    url.replaceAll("/", ".");
                }
                if (LoggerUtils.isNull(url)) {
                    url = this.initFuncID(msgList);
                }
                if (!LoggerUtils.isNull(url)) {
                    url = url + "/";
                }
                String filePath = Env.env().baseDir() + "/logs/errorlogs/" + LoggerUtils.date2String(new Date(), "yyyy/MM/dd") + "/" + url;
                String fileName = LoggerUtils.date2String(new Date(), "yyyy-MM-dd-HH.mm.ss") + "_" + threadUUID + ".txt";
                write.write(filePath + fileName, this.map2List(msgList));
                removeList.add(threadUUID);
                Ulog.cacheManager.delMessage(threadUUID);
            }
            TODB_LIST.removeAll(removeList);
        }
    }

    public static int errorThreadNum() {
        return TODB_LIST.size();
    }

    public static ErrorLoggerWrite getWrite() {
        return write;
    }

    public static void setWrite(ErrorLoggerWrite write) {
        ErrorLogger.write = write;
    }

    private String initFuncID(Map<String, String> msgList) {
        int classNameEndIndex;
        String lastLog = msgList.get(msgList.size() + "");
        int classNameStartIndex = lastLog.substring(0, classNameEndIndex = lastLog.indexOf(".java:")).lastIndexOf(" ");
        if (classNameStartIndex < classNameEndIndex) {
            return lastLog.substring(classNameStartIndex + 1, classNameEndIndex + 5);
        }
        return "";
    }

    private Collection<String> map2List(Map<String, String> msgList) {
        TreeMap<String, String> tree = new TreeMap<String, String>(new Comparator<String>(){

            @Override
            public int compare(String obj1, String obj2) {
                Long key1 = Long.parseLong(obj1);
                Long key2 = Long.parseLong(obj2);
                if (key1 < key2) {
                    return -1;
                }
                if (key1 > key2) {
                    return 1;
                }
                return 0;
            }
        });
        tree.putAll(msgList);
        return tree.values();
    }
}

