/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.logger;

import com.uniapis.logger.Env;
import com.uniapis.logger.LoggerUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

class Console {
    private static final Logger logger = LogManager.getLogger();

    Console() {
    }

    static void info(String msg, String call) {
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        logger.info(Console.splitMsg(msg) + call);
    }

    static void warn(String msg, String call) {
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        logger.warn(Console.splitMsg(msg) + call);
    }

    static void error(String msg, String call) {
        if (LoggerUtils.isNull(msg)) {
            return;
        }
        logger.error(Console.splitMsg(msg) + call);
    }

    private static String splitMsg(String msg) {
        if (Env.env().logMaxLength() < 0) {
            return msg;
        }
        if (msg.length() > Env.env().logMaxLength()) {
            return msg.substring(0, Env.env().logMaxLength() - 1) + "...";
        }
        return msg;
    }
}

