/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.generate.repository.controller;

import com.uniapis.generate.repository.services.IGenerateModelService;
import com.uniapis.logger.Ulog;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.repository.core.utils.SpringContext;
import com.uniapis.repository.sharding.Shardingable;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.StrUtils;
import com.uniapis.web.utils.RequestMap;
import com.uniapis.web.utils.RequestUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.compress.utils.IOUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.http.ResponseEntity;
import org.springframework.util.MultiValueMap;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.client.RestTemplate;
import org.springframework.web.multipart.MultipartFile;

@RestController
@RequestMapping(value={"/generate"})
public class GenerateModelController {
    @Autowired
    private IGenerateModelService generateModelService;
    @Autowired
    private RestTemplate restTemplate;
    @Autowired
    @Value(value="${server.port}")
    private String port;
    @Value(value="${uniapis.testWach:123}")
    private String testWatch;

    @RequestMapping(value={"/v1.0/model"}, produces={"application/zip"})
    public ResponseEntity<byte[]> generateModel(String pkgName, String schema, String tables, String enums) throws IOException {
        ReturnMsg msg = this.generateModelService.generateModel(StrUtils.trimStr((Object)pkgName), StrUtils.trimStr((Object)schema), StrUtils.trimStr((Object)tables), StrUtils.trimStr((Object)enums));
        String dir = (String)msg.getDataTable((Object)"dir", String.class);
        dir = dir.substring(0, dir.indexOf(pkgName.split("\\.")[0]));
        String target = FileUtils.zip((String)dir, (String[])new String[]{".java"});
        HttpHeaders headers = new HttpHeaders();
        String[] targetArray = target.split("/");
        String fileName = StrUtils.trimStr((Object)targetArray[targetArray.length - 1]);
        headers.setContentType(MediaType.APPLICATION_OCTET_STREAM);
        headers.set("file_name", new String(fileName.getBytes("UTF-8"), "ISO8859-1"));
        headers.setContentDispositionFormData("attachment", new String(fileName.getBytes("UTF-8"), "ISO8859-1"));
        return new ResponseEntity((Object)IOUtils.toByteArray((InputStream)new FileInputStream(new File(target))), (MultiValueMap)headers, HttpStatus.CREATED);
    }

    @RequestMapping(value={"/v1.0/test"})
    public String testVersion() {
        Ulog.info((String)"/v1.0/test");
        return "testVersion v1.0/test port=" + this.port;
    }

    @RequestMapping(value={"/v1.0/fileUpload"})
    public String testFileUpload(MultipartFile file, HttpServletRequest request) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        Ulog.info((String)map.get("image_type"));
        Ulog.info((String)file.getName());
        return "testVersion v1.0/fileUpload port=" + this.port;
    }

    @RequestMapping(value={"/v1.0/testNotJson"})
    public String testNotJson(HttpServletRequest request, HttpServletResponse response) {
        RequestMap map = RequestUtils.getRequest((HttpServletRequest)request);
        return "testVersion v1.0/fileUpload port=" + this.port;
    }

    @RequestMapping(value={"/v1.0/call"})
    public String callGenerate(String version) {
        Ulog.info((String)("Shardingable name ===" + ((Shardingable)SpringContext.getBean(Shardingable.class)).getClass().getName()));
        Ulog.info((String)("===== testWatch = " + this.testWatch));
        String msg = (String)this.restTemplate.getForObject("http://foundation-generate/generate/" + version + "/test", String.class, new Object[0]);
        return "call port=" + this.port + " return = " + msg;
    }
}

