package ${DaoModel.packageName};

[#assign isHaveDate = false]
[#assign isHaveTimestamp = false]
[#list DaoModel.clmList as aClm]
    [#if !isHaveDate && aClm.dataType == "date"]
import java.util.Date;
        [#assign isHaveDate = true]
    [/#if]
    [#if !isHaveTimestamp && (aClm.dataType == "datetime" || aClm.dataType?contains("timestamp"))]
import java.sql.Timestamp;
        [#assign isHaveTimestamp = true]
    [/#if]
    [#if DaoModel.enumClass[aClm.clmName]??]
import ${DaoModel.packageName}.enums.${DaoModel.enumClass[aClm.clmName]};
    [/#if]
[/#list]
[#if isHaveDate || isHaveTimestamp]
import com.fasterxml.jackson.annotation.JsonFormat;
[/#if]
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.uniapis.msg.Return;
import com.uniapis.repository.core.AbsModel;
import com.uniapis.repository.core.Field;
import com.uniapis.repository.core.group.GroupBy;
import com.uniapis.repository.core.where.Where;
import com.uniapis.utils.StrUtils;
[#if isHaveDate]
import com.uniapis.utils.DateUtils;
[/#if]
import org.springframework.data.domain.Sort;

import javax.persistence.Column;
import javax.persistence.Table;
import javax.persistence.Transient;

/**
 * @author auto generate ${.now?string["yyyy/MM/dd"]}
 */
@Table(name = "${DaoModel.tableName}")
public class ${DaoModel.className} extends AbsModel {

[#list DaoModel.clmList as aClm]
[#-- 属性类型，默认为字符类型 --]
    [#assign dataType = "String"]
    [#assign defValue = ""]
[#-- 包含int，就是数值类型--]
    [#if aClm.dataType?contains("int") || aClm.dataType?contains("number")]
        [#assign dataType = "Integer"]
    [/#if]
[#-- date类型，就是日期类型--]
    [#if aClm.dataType == "date"]
        [#assign dataType = "Date"]
    @JsonFormat(pattern = "yyyy-MM-dd")
    [/#if]
[#-- datetime和timestamp类型，是Timestamp类型--]
    [#if aClm.dataType == "datetime" || aClm.dataType?contains("timestamp")]
        [#assign dataType = "Timestamp"]
    @JsonFormat(pattern = "yyyy-MM-dd HH:mm:ss")
    [/#if]
[#-- 包含decimal或者以decimal结尾，就是double类型--]
    [#if aClm.dataType?contains("decimal") || aClm.clmName?ends_with("decimal")]
        [#assign dataType = "Double"]
    [/#if]
    [#if aClm.clmName=="data_flag"]
        [#assign defValue = " = \"1\""]
    [/#if]
    /**
     * ${aClm.clmComment}
     */
    @Column(name = "${aClm.clmName}")
    @JsonProperty("${aClm.clmName}")
    [#if aClm.dataType?contains("decimal") || aClm.clmName?ends_with("decimal")]
        [#assign dataType = "Double"]
    [/#if]
    private ${dataType} ${aClm.propertyName?uncap_first}${defValue};

[/#list]
    public ${DaoModel.className}() {
    }

    public ${DaoModel.className}(boolean appendWhere) {
        super(appendWhere);
    }

    public Return checkValue() {
        Return ret = new Return();
[#list DaoModel.clmList as aClm]

        // ${aClm.clmName}
        // ${aClm.clmComment}
[#-- 包含char，就是字符类型--]
    [#if aClm.dataType?contains("char") && !DaoModel.enumClass[aClm.clmName]??]
        String ${aClm.propertyName?uncap_first} = StrUtils.trimStr(this.${aClm.propertyName?uncap_first});
        if (${aClm.propertyName?uncap_first}.length() > ${aClm.maxLength}) {
            ret.setFailMsg("[${aClm.clmComment}]不能超过[${aClm.maxLength}]位，实际为[" + ${aClm.propertyName?uncap_first}.length() + "]位");
        }
    [/#if]
    [#if aClm.isNull == "no"]
        if (StrUtils.isNull(this.${aClm.propertyName?uncap_first})) {
            ret.setFailMsg("[${aClm.clmComment}]不能为空");
        }
    [/#if]
[#-- 包含int，就是数值类型--]
    [#if aClm.dataType?contains("int") || aClm.dataType?contains("number")]
        if (!StrUtils.isNull(this.${aClm.propertyName?uncap_first}) && !StrUtils.isNum(this.${aClm.propertyName?uncap_first})) {
            ret.setFailMsg("[${aClm.clmComment}]必须为数字，实际为[" + this.${aClm.propertyName?uncap_first} + "]");
        }
    [/#if]
[/#list]
        return ret;
    }

[#assign enumList = ""]
[#list DaoModel.clmList as aClm]
    [#assign enumList += aClm.clmName + "(\""+aClm.propertyName?uncap_first+"\", \""+aClm.clmName+"\"), "]
    [#assign dataType = "String"][#-- 属性类型，默认为字符类型 --]
[#-- 包含int，就是数值类型--]
    [#if aClm.dataType?contains("int") || aClm.dataType?contains("number")]
        [#assign dataType = "Integer"]
    [/#if]
[#-- date类型，就是日期类型--]
    [#if aClm.dataType == "date"]
        [#assign dataType = "Date"]
    [/#if]
[#-- datetime和timestamp类型，是Timestamp类型--]
    [#if aClm.dataType == "datetime" || aClm.dataType?contains("timestamp")]
        [#assign dataType = "Timestamp"]
    [/#if]
[#-- 包含decimal或者以decimal结尾，就是double类型--]
    [#if aClm.dataType?contains("decimal") || aClm.clmName?ends_with("decimal")]
        [#assign dataType = "Double"]
    [/#if]
    /**
     *
     * @param ${aClm.propertyName?uncap_first}
     *            ${aClm.clmComment}
     */
    public ${DaoModel.className} set${aClm.propertyName}(${dataType} ${aClm.propertyName?uncap_first}) {
        [#if DaoModel.enumClass[aClm.clmName]??]
        ${DaoModel.enumClass[aClm.clmName]}.valueOf(${aClm.propertyName?uncap_first});
        [/#if]
        [#if dataType == "Date"]
        this.${aClm.propertyName?uncap_first} = DateUtils.trunc(${aClm.propertyName?uncap_first});
        [#else]
        this.${aClm.propertyName?uncap_first} = ${aClm.propertyName?uncap_first};
        [/#if]
        this.where().setChangeColumn(${DaoModel.className}.${aClm.clmName?upper_case});
        return this;
    }

    /**
     *
     * @return 返回${aClm.clmComment}
     */
    public ${dataType} get${aClm.propertyName}() {
        return this.${aClm.propertyName?uncap_first};
    }

    [#if DaoModel.enumClass[aClm.clmName]??]
    /**
     *
     * @param ${aClm.propertyName?uncap_first}
     *            ${aClm.clmComment}
     */
    public ${DaoModel.className} set${aClm.propertyName}(${DaoModel.enumClass[aClm.clmName]} ${aClm.propertyName?uncap_first}) {
        this.${aClm.propertyName?uncap_first} = ${aClm.propertyName?uncap_first}.code();
        this.where().setChangeColumn(${DaoModel.className}.${aClm.clmName?upper_case});
        return this;
    }

    /**
     *
     * @return 返回${aClm.clmComment}
     */
    public ${DaoModel.enumClass[aClm.clmName]} get${aClm.propertyName}Enum() {
        if(StrUtils.isNull(this.${aClm.propertyName?uncap_first})){
            return null;
        }
        return ${DaoModel.enumClass[aClm.clmName]}.valueOf(this.${aClm.propertyName?uncap_first});
    }
    [/#if]
[/#list]

    @Override
    @JsonIgnore
    public ${DaoModel.className} select(Field... fields) {
        super.select(fields);
        return this;
    }

    @Transient
    @JsonIgnore
    private Where<${DaoModel.className}> where = Where.getInstance(this);

    @Override
    @JsonIgnore
    public Where<${DaoModel.className}> where() {
        return this.where;
    }

    @Transient
    @JsonIgnore
    private GroupBy<${DaoModel.className}> groupby = GroupBy.getInstance(this);

    @Override
    @JsonIgnore
    public GroupBy<${DaoModel.className}> groupBy() {
        return this.groupby;
    }

    @Override
    @JsonIgnore
    public ${DaoModel.className} setOrderBy(Sort.Order... order) {
        super.setOrderBy(order);
        return this;
    }

    @JsonIgnore
    public static ${DaoModel.className} n() {
        return new ${DaoModel.className}();
    }


    @JsonIgnore
    public static ${DaoModel.className} n(boolean appendWhere) {
        return new ${DaoModel.className}(appendWhere);
    }

[#assign baseClmEnum = ""]
[#list DaoModel.clmList as aClm]
    @Transient
    public static final Field ${aClm.clmName?upper_case} = new Field("${aClm.propertyName?uncap_first}", "${aClm.clmName}", "${aClm.clmComment}");
[/#list]
}