/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.generate.repository.services.impl;

import com.uniapis.generate.freemark.ConfigurationHelper;
import com.uniapis.generate.repository.pojo.DaoModel;
import com.uniapis.generate.repository.services.IGenerateModelService;
import com.uniapis.logger.Env;
import com.uniapis.msg.Return;
import com.uniapis.msg.ReturnMsg;
import com.uniapis.msg.exception.BusinessException;
import com.uniapis.repository.config.DataSourceProperties;
import com.uniapis.repository.core.AbsModelRepository;
import com.uniapis.repository.core.DBTypes;
import com.uniapis.repository.core.utils.RepUtils;
import com.uniapis.utils.FileUtils;
import com.uniapis.utils.StrUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class GenerateModelServiceImpl
implements IGenerateModelService {
    @Autowired
    private AbsModelRepository dao;

    @Override
    public ReturnMsg generateModel(String pkgName, String schema, String tables, String enums) {
        List<DaoModel> models = null;
        if (DataSourceProperties.dbTypes().equals((Object)DBTypes.MYSQL)) {
            models = this.queryTabList4Mysql(pkgName, schema, tables);
        }
        if (DataSourceProperties.dbTypes().equals((Object)DBTypes.ORACLE)) {
            models = this.queryTabList4Oracle(pkgName, tables);
        }
        if (models == null || models.isEmpty()) {
            return new Return("\u672a\u67e5\u627e\u5230\u8981\u751f\u6210\u7684\u6570\u636e\u5e93\u8868").msg();
        }
        String baseDir = Env.env().baseDir() + "/generate/repository/" + models.get(0).getClassName() + "/" + System.currentTimeMillis() + "/";
        Map<String, String> enumClass = this.generateEnums(enums, pkgName, baseDir);
        models.forEach(m -> m.setEnumClass(enumClass));
        String dir = this.generateJava(models, baseDir);
        Return msg = new Return();
        msg.getDataTable().put("dir", dir);
        return msg.msg();
    }

    private Map<String, String> generateEnums(String enums, String pkgName, String baseDir) {
        HashMap<String, String> enumClass = new HashMap<String, String>();
        if (StrUtils.isNull((Object)enums)) {
            return enumClass;
        }
        List<DaoModel> enumList = Arrays.stream(enums.split(";")).map(enumStr -> enumStr.split(":")).map(arr -> {
            DaoModel model = new DaoModel();
            String field = arr[0].toLowerCase();
            if (!field.contains("@")) {
                String className = this.parseClassName(field);
                enumClass.put(field, className);
                model.setPackageName(pkgName + ".enums");
                model.setClassName(className);
                model.initEnums(arr[1]);
            } else {
                String[] fieldArr = field.split("@");
                String className = this.parseClassName(fieldArr[1]);
                enumClass.put(fieldArr[0], className);
                model.setPackageName(pkgName + ".enums");
                model.setClassName(className);
                model.initEnums(arr[1]);
            }
            return model;
        }).collect(Collectors.toList());
        this.generateJava(enumList, "/repository/EnumModelSample.ftl", baseDir);
        return enumClass;
    }

    private String generateJava(List<DaoModel> models, String baseDir) {
        return this.generateJava(models, "/repository/AbsModelSample.ftl", baseDir);
    }

    private String generateJava(List<DaoModel> models, String ftlName, String baseDir) {
        Template template;
        Configuration config = ConfigurationHelper.getConfiguration();
        try {
            template = config.getTemplate(ftlName);
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new BusinessException("\u672a\u67e5\u627e\u5230[" + ftlName + "]\u5bf9\u5e94\u7684ftl\u914d\u7f6e\u6587\u4ef6");
        }
        HashMap<String, DaoModel> data = new HashMap<String, DaoModel>();
        String dir = baseDir + models.get(0).getPackageName().replaceAll("\\.", "/") + "/";
        File dirFile = new File(dir);
        dir = dirFile.getPath();
        for (DaoModel model : models) {
            data.put("DaoModel", model);
            FileUtils.createDirs((String)dir);
            String className = model.getClassName();
            try (OutputStreamWriter out = new OutputStreamWriter((OutputStream)new FileOutputStream(dir + "/" + className + ".java"), "UTF-8");){
                template.process(data, (Writer)out);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw new BusinessException("\u751f\u6210" + model.getClassName() + "\u7c7b\u51fa\u9519", (Throwable)e);
            }
        }
        return dir;
    }

    private List<DaoModel> queryTabList(String pkgName, String schema, String tables, Function<String, List> allTable, Function<String, List> clms) {
        List tableList = allTable.apply(schema);
        ArrayList<DaoModel> modelList = new ArrayList<DaoModel>();
        List clmList = null;
        tables = "," + tables + ",";
        for (Map tableMap : tableList) {
            String lowTabName = tableMap.get("table_name").toString().toLowerCase();
            if (tables.indexOf("," + lowTabName + ",") < 0) continue;
            DaoModel model = new DaoModel();
            model.setPackageName(pkgName);
            model.setClassName(this.parseClassName(lowTabName));
            model.setTableName(lowTabName);
            clmList = clms.apply(StrUtils.trimStr(tableMap.get("table_name")));
            for (Map clmName : clmList) {
                String lowClmName = StrUtils.trimStr(clmName.get("column_name")).toLowerCase();
                String clmComment = RepUtils.F.replaceSpace(StrUtils.trimStr(clmName.get("column_comment")));
                String isNull = StrUtils.trimStr(clmName.get("is_null")).toLowerCase();
                String dataType = StrUtils.trimStr(clmName.get("data_type")).toLowerCase();
                String maxLength = StrUtils.trimStr(clmName.get("max_length")).toLowerCase();
                if (model.getBaseList().contains(lowClmName)) continue;
                model.addClmList(lowClmName, clmComment, isNull, dataType, maxLength);
            }
            modelList.add(model);
        }
        return modelList;
    }

    private List<DaoModel> queryTabList4Mysql(String pkgName, String schema, String tables) {
        return this.queryTabList(pkgName, schema, tables, s -> {
            String userTable = "SELECT table_name FROM information_schema.tables WHERE table_schema=? \uff03NOTCHECK";
            return this.dao.findAll(userTable, new AbsModelRepository.Args[]{this.dao.args(new Object[]{s})});
        }, tableName -> {
            String tableClm = "SELECT column_name, column_comment, is_nullable is_null, data_type, character_maximum_length max_length FROM information_schema.columns   WHERE table_name=? AND table_schema = ? ORDER BY ordinal_position  \uff03NOTCHECK";
            return this.dao.findAll(tableClm, new AbsModelRepository.Args[]{this.dao.args(new Object[]{tableName, schema})});
        });
    }

    private List<DaoModel> queryTabList4Oracle(String pkgName, String tables) {
        return this.queryTabList(pkgName, "", tables, schema -> {
            String userTable = "SELECT table_name FROM user_tables \uff03NOTCHECK";
            return this.dao.findAll(userTable, new AbsModelRepository.Args[0]);
        }, tableName -> {
            String tableClm = "SELECT distinct t.column_name,l.comments column_comment, data_type,   CASE t.nullable WHEN 'Y' THEN 'YES' WHEN 'N' THEN 'NO' END  is_null,   CASE data_type WHEN 'TIMESTAMP(6) ' THEN null WHEN 'DATE' THEN null ELSE t.data_length END max_length   FROM user_tab_columns t LEFT JOIN user_col_comments l ON t.column_name = l.column_name    WHERE l.table_name = ? AND t.table_name = ? ORDER BY t.column_id  \uff03NOTCHECK";
            return this.dao.findAll(tableClm, new AbsModelRepository.Args[]{this.dao.args(new Object[]{tableName, tableName})});
        });
    }

    private String parseClassName(String tabName) {
        String[] nameChar = tabName.split("_");
        StringBuilder tableName = new StringBuilder();
        for (String name : nameChar) {
            StrUtils.append((StringBuilder)tableName, (String[])new String[]{StrUtils.uppFstChar((Object)name)});
        }
        return tableName.toString();
    }
}

