/*
 * Decompiled with CFR 0.152.
 */
package com.uniapis.cache;

import com.uniapis.cache.Cache;
import com.uniapis.logger.Ulog;
import com.uniapis.utils.JsonUtils;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;

public class CacheManager {
    private static Cache cache;

    @Autowired
    public CacheManager(Cache cache) {
        CacheManager.cache = cache;
    }

    public static void put(String key, Object value) {
        Ulog.info((String)("redis put key = " + key));
        cache.put(key, value);
    }

    public static void put(String key, Object value, int timeout) {
        Ulog.info((String)("redis put key = " + key));
        cache.put(key, value, timeout);
    }

    public static Object get(String key) {
        return cache.get(key);
    }

    public static <T> T get(String key, Class<T> requiredType) {
        return cache.get(key, requiredType);
    }

    public static void remove(String key) {
        Ulog.info((String)("redis remove key = " + key));
        cache.remove(key);
    }

    public static Set<String> keys(String pattern) {
        return cache.keys(pattern);
    }

    public static void putHash(String key, Map<?, ?> value) {
        Ulog.info((String)("redis putHash key = " + key));
        cache.putHash(key, value);
    }

    public static void putHash(String key, String hashKey, Object value) {
        CacheManager.putHash(key, hashKey, value, true);
    }

    public static void putHash(String key, String hashKey, Object value, boolean showLog) {
        if (showLog) {
            Ulog.info((String)("redis putHash key = " + key + " | " + hashKey));
        }
        cache.putHash(key, hashKey, value);
    }

    public static Map<?, ?> getHash(String key) {
        return cache.getHash(key);
    }

    public static Object getHash(String key, String hashKey) {
        return cache.getHash(key, hashKey);
    }

    public static <T> T getHash(String key, String hashKey, Class<T> requiredType) {
        return cache.getHash(key, hashKey, requiredType);
    }

    public static void removeHash(String key) {
        Ulog.info((String)("redis removeHash key = " + key));
        cache.removeHash(key);
    }

    public static void removeHash(String key, Object ... hashKeys) {
        Ulog.info((String)("redis removeHash key = " + key + " | " + JsonUtils.toJson((Object)hashKeys)));
        cache.removeHash(key, hashKeys);
    }

    public static Long hashSize(String key) {
        return cache.hashSize(key);
    }

    public static void put(Map<String, ?> data) {
        Ulog.info((String)("redis put key = " + JsonUtils.toJson(data.keySet())));
        cache.put(data);
    }

    public static boolean zAdd(String key, Object value) {
        Ulog.info((String)("redis zAdd key = " + key));
        return cache.zAdd(key, value);
    }

    public static boolean zAdd(String key, Object value, double score) {
        Ulog.info((String)("redis zAdd key = " + key));
        return cache.zAdd(key, value, score);
    }

    public static Set<Object> zGetByRank(String key, long start, long end) {
        return cache.zGetByRank(key, start, end);
    }

    public static Set<Object> zGetByScore(String key, double min, double max) {
        return cache.zGetByScore(key, min, max);
    }

    public static Long zRemove(String key, Object ... values) {
        Ulog.info((String)("redis zRemove key = " + key));
        return cache.zRemove(key, values);
    }

    public static Long zRemoveByRank(String key, long start, long end) {
        Ulog.info((String)("redis zRemoveByRank key = " + key + " | " + start + " | " + end));
        return cache.zRemoveByRank(key, start, end);
    }

    public static Long zRemoveByScore(String key, double min, double max) {
        Ulog.info((String)("redis zRemoveByScore key = " + key + " | " + min + " | " + max));
        return cache.zRemoveByScore(key, min, max);
    }

    public static Long leftPush(String key, Object value) {
        Ulog.info((String)("redis leftPush key = " + key));
        return cache.leftPush(key, value);
    }

    public static Long rightPush(String key, Object value) {
        Ulog.info((String)("redis rightPush key = " + key));
        return cache.rightPush(key, value);
    }

    public static Object leftPop(String key) {
        Ulog.info((String)("redis leftPop key = " + key));
        return cache.leftPop(key);
    }

    public static Object rightPop(String key) {
        Ulog.info((String)("redis rightPop key = " + key));
        return cache.rightPop(key);
    }

    public static Object blockLeftPop(String key) {
        Ulog.info((String)("redis blockLeftPop key = " + key));
        return cache.blockLeftPop(key);
    }

    public static Object blockLeftPop(String key, long timeout) {
        Ulog.info((String)("redis blockLeftPop key = " + key));
        return cache.blockLeftPop(key, timeout);
    }

    public static Object blockRightPop(String key) {
        Ulog.info((String)("redis blockRightPop key = " + key));
        return cache.blockRightPop(key);
    }

    public static Object blockRightPop(String key, long timeout) {
        Ulog.info((String)("redis blockRightPop key = " + key));
        return cache.blockRightPop(key, timeout);
    }

    public static List<Object> range(String key, long start, long end) {
        return cache.range(key, start, end);
    }

    public static void listRemove(String key, long count, Object value) {
        Ulog.info((String)("redis listRemove key = " + key + " | " + count));
        cache.listRemove(key, count, value);
    }

    public static Long listSize(String key) {
        return cache.listSize(key);
    }

    public static boolean expire(String key, long timeout) {
        return cache.expire(key, timeout);
    }

    public static Cache getCache() {
        return cache;
    }

    public static long incr(String key, long delta) {
        Ulog.info((String)("redis incr key = " + key));
        return cache.incr(key, delta);
    }

    public static long decr(String key, long delta) {
        Ulog.info((String)("redis decr key = " + key));
        return cache.decr(key, delta);
    }

    public static void putSimple(String key, String value) {
        Ulog.info((String)("redis putSimple key = " + key));
        cache.putSimple(key, value);
    }

    public static void putSimple(String key, String value, int timeout) {
        Ulog.info((String)("redis putSimple key = " + key));
        cache.putSimple(key, value, timeout);
    }

    public static Object getSimple(String key) {
        return cache.getSimple(key);
    }
}

